/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements;

import java.util.HashMap;
import java.util.LinkedList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import org.eclipse.app4mc.multicore.execution.ui.widget.comunication.ComUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ArrowElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DurationModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ProgressViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventChain;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XTasks;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.TraceWidget;

public class MultysamplingViewElement
extends ProgressViewElement {
    private boolean mergeArrow;
    private boolean underSampling;
    private boolean overSampling;
    private boolean follow;
    private boolean countable;
    private String core;
    private XEventChain ec;
    private String affected;
    private LinkedList<ArrowElement> list;
    private MultysamplingViewElement nextLink = null;
    private LinkedList<Boolean> overBooList;
    private HashMap<String, Long> underBooList;
    private XTasks task;
    private String style;
    private Tooltip t;

    public MultysamplingViewElement(final XTasks task, String style, final DurationModelElement model, boolean mergeArrow, String core, XEventChain ec) {
        super(style, model, new TraceWidget.ArrowTooltip(task.getName(), null, model.getStart(), (long)model.getDuration(), "Running"), false);
        this.mergeArrow = mergeArrow;
        this.underSampling = true;
        this.overSampling = false;
        this.core = core;
        this.ec = ec;
        this.follow = false;
        this.affected = "";
        this.style = style;
        this.list = new LinkedList();
        this.overBooList = new LinkedList();
        this.underBooList = new HashMap();
        this.task = task;
        this.countable = true;
        EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                switch (event.getButton()) {
                    case PRIMARY: {
                        boolean found;
                        XTasks cur;
                        LinkedList<ComUtil.CollumEntry> outOver = new LinkedList<ComUtil.CollumEntry>();
                        LinkedList<ComUtil.CollumEntry> outUnder = new LinkedList<ComUtil.CollumEntry>();
                        for (String tt : task.getProducer().keySet()) {
                            cur = task.getProducer().get(tt);
                            found = false;
                            for (Object element : MultysamplingViewElement.this.list) {
                                if (element.getParrentTask().compareTo(cur.getName()) != 0) continue;
                                String[] arr = element.getStatistic().split(",");
                                String ttspm = "";
                                if (((Boolean)MultysamplingViewElement.this.overBooList.get(MultysamplingViewElement.this.containsInt(cur.getName()))).booleanValue()) {
                                    ttspm = "Oversampling";
                                }
                                outOver.add(new ComUtil.CollumEntry(arr[0], arr[1], "[ have data ]", ttspm));
                                found = true;
                            }
                            if (found) continue;
                            outOver.add(new ComUtil.CollumEntry(cur.getName(), "", "[ no data ]", ""));
                        }
                        for (String tt : task.getConsumer().keySet()) {
                            cur = task.getConsumer().get(tt);
                            found = false;
                            for (Object element : MultysamplingViewElement.this.underBooList.keySet()) {
                                if (((String)element).compareTo(tt) != 0) continue;
                                outUnder.add(new ComUtil.CollumEntry(tt, "" + MultysamplingViewElement.this.underBooList.get(element), "[ have data ]", ""));
                                found = true;
                            }
                            if (found) continue;
                            outUnder.add(new ComUtil.CollumEntry(cur.getName(), "", "[ no data ]", "Undersampling"));
                        }
                        ComUtil.taskInfo(task.getName(), model.getStart(), (double)model.getStart() + model.getDuration(), MultysamplingViewElement.this.underSampling, MultysamplingViewElement.this.overSampling, outOver, outUnder);
                        StringBuilder sb = new StringBuilder();
                        sb.append("\n");
                        sb.append(String.valueOf(MultysamplingViewElement.this.underBooList.size()) + " / " + task.getConsumer().size());
                        sb.append("Sollen:\n");
                        for (String cur2 : task.getConsumer().keySet()) {
                            sb.append(cur2);
                            sb.append(" should linked");
                            sb.append("\n");
                        }
                        sb.append("Sind:\n");
                        for (String cur2 : MultysamplingViewElement.this.underBooList.keySet()) {
                            sb.append(cur2);
                            sb.append(" islinked");
                            sb.append("\n");
                        }
                        break;
                    }
                }
            }
        };
        if (mergeArrow) {
            this.setCursor(Cursor.HAND);
            this.setOnMouseClicked((EventHandler)handler);
            this.t = new Tooltip("Task " + task.getName() + " running\n" + model.getStart() + " to " + ((double)model.getStart() + model.getDuration()) + "\n" + "[Left Click] - Get more information" + "\n");
        } else {
            this.t = new Tooltip("Task " + task.getName() + " running\n" + model.getStart() + " to " + ((double)model.getStart() + model.getDuration()) + "\n");
        }
        Tooltip.install((Node)this, (Tooltip)this.t);
        this.validateUndersampling();
        this.styleCollection();
    }

    @Override
    protected void updateElement(FXGanttWidget chart) {
        super.updateElement(chart);
        this.setHeight(this.getHeight());
    }

    public void setOverSampling(String task) {
        this.overSampling = true;
        this.overBooList.set(this.containsInt(task), true);
        this.styleCollection();
    }

    public boolean getOverSampling(String task) {
        return this.overBooList.get(this.containsInt(task));
    }

    public void setUnderSampling() {
        this.underSampling = false;
        this.styleCollection();
    }

    public void styleCollection() {
        String in = "";
        if (this.underSampling && this.overSampling) {
            in = "multy";
        }
        if (!this.underSampling && this.overSampling) {
            in = "over";
        }
        if (this.underSampling && !this.overSampling) {
            in = "under";
        }
        switch (in) {
            case "multy": {
                this.getStyleClass().remove((Object)this.style);
                this.style = "status-multi";
                this.getStyleClass().add((Object)"status-multi");
                break;
            }
            case "over": {
                this.getStyleClass().remove((Object)this.style);
                this.style = "status-over";
                this.getStyleClass().add((Object)"status-over");
                break;
            }
            case "under": {
                this.getStyleClass().remove((Object)this.style);
                this.style = "status-under";
                this.getStyleClass().add((Object)"status-under");
                break;
            }
            default: {
                this.getStyleClass().remove((Object)this.style);
                this.style = "status-light-green";
                this.getStyleClass().add((Object)"status-light-green");
            }
        }
    }

    public boolean isMergeArrow() {
        return this.mergeArrow;
    }

    public boolean isUnderSampling() {
        return this.underSampling;
    }

    public boolean isOverSampling() {
        return this.overSampling;
    }

    public String getCore() {
        return this.core;
    }

    public XEventChain getEc() {
        return this.ec;
    }

    public String getAffected() {
        return this.affected;
    }

    public void addArrow(ArrowElement elen) {
        this.list.add(elen);
        this.overBooList.add(false);
    }

    public void validateUndersampling() {
        if (this.task.getConsumer() == null || !this.mergeArrow) {
            this.underSampling = false;
            this.styleCollection();
        } else if (this.task.getConsumer() != null && this.underBooList.size() == this.task.getConsumer().size()) {
            this.setUnderSampling();
        }
    }

    public boolean contains(String in) {
        for (ArrowElement el : this.list) {
            if (el.getParrentTask().compareTo(in) != 0) continue;
            return true;
        }
        return false;
    }

    private int containsInt(String in) {
        int a = 0;
        for (ArrowElement el : this.list) {
            if (el.getParrentTask().compareTo(in) == 0) {
                return a;
            }
            ++a;
        }
        return -1;
    }

    public void tellProducer(String name, long start) {
        if (this.underBooList.get(name) == null) {
            this.underBooList.put(name, start);
            System.out.println(String.valueOf(name) + " tells " + this.task.getName());
        }
        this.validateUndersampling();
    }

    public boolean isFollow() {
        return this.follow;
    }

    public void setFollow(boolean follow) {
        this.follow = follow;
        if (follow) {
            this.underSampling = false;
            this.overSampling = false;
            this.styleCollection();
        }
    }

    public void mergeMe(MultysamplingViewElement inEl, boolean val) {
        inEl.nextLink = this;
        this.overBooList = inEl.overBooList;
        this.underBooList = inEl.underBooList;
        this.mergeArrow = inEl.mergeArrow;
        this.overSampling = inEl.overSampling;
        this.affected = inEl.affected;
        this.underSampling = inEl.underSampling;
        this.list = inEl.list;
        this.styleCollection();
        if (val) {
            new Thread(() -> {
                try {
                    Thread.sleep(20000L);
                    this.mergeMe(inEl, false);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }

    public void diableCount() {
        this.countable = false;
    }

    public boolean isCountable() {
        return this.countable;
    }

    public XTasks getTask() {
        return this.task;
    }
}

