/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DurationModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.TraceWidget;

public class ProgressViewElement
extends AbstractGanttViewElement {
    private DurationModelElement model;

    public ProgressViewElement(String style, DurationModelElement model) {
        super(style);
        this.model = model;
        try {
            String tip = "Time: " + model.getStart() + " to " + ((double)model.getStart() + model.getDuration()) + "\nInfo: " + model.getLabel();
            Tooltip t = new Tooltip(tip);
            Tooltip.install((Node)this, (Tooltip)t);
        }
        catch (Exception exception) {}
    }

    public ProgressViewElement(String style, DurationModelElement model, TraceWidget.ArrowTooltip el, boolean sel) {
        super(style);
        this.model = model;
        if (sel && el != null) {
            Tooltip t = new Tooltip("Time: " + el.getStart() + " to " + (el.getStart() + el.getTime()) + "\nInfo: " + el.getLabel());
            Tooltip.install((Node)this, (Tooltip)t);
        }
    }

    @Override
    protected void updateElement(FXGanttWidget chart) {
        this.setWidth(this.model.getDuration() * chart.getNumberAxis().getScale());
        this.setHeight(chart.getBlockHeight());
    }

    public DurationModelElement getModel() {
        return this.model;
    }
}

