/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitImpl;
import org.eclipse.app4mc.amalthea.model.util.HardwareUtil;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.MultysamplingViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XAccess;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XCore;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventChain;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XLabel;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XMappingUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XRunnable;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XScheduler;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XTasks;
import org.eclipse.emf.common.util.EList;

public class XContainer {
    StringBuilder sb;
    private LinkedList<LinkedList<ChainElement>> globalChain;
    private HashMap<String, XCore> cores;
    private HashMap<String, XTasks> tasks;
    private HashMap<String, XRunnable> runnables;
    private HashMap<String, XLabel> labels;
    private HashMap<String, XScheduler> scheduler;
    private HashMap<String, XEventChain> chain;
    private boolean bLabelsNumCheckPassed;
    private boolean bRunnableNumCheckPassed;
    private boolean bCoreNumCheckPassed;
    private boolean bTaskNumCheckPassed;
    private boolean bSchedulerNumCheckPassed;
    private static XContainer self;
    private boolean labelView;
    private boolean dataFlow;
    private boolean mergingArrow;
    private boolean alternativeArrow;
    private boolean haveglobal;
    public boolean isRun;

    public static XContainer getInstance(Amalthea model) {
        if (model != null && self == null) {
            self = new XContainer(model);
            XContainer.self.isRun = true;
        } else if (model == null && self == null) {
            self = new XContainer();
            XContainer.self.isRun = false;
        }
        return self;
    }

    public static XContainer newInstance() {
        self = new XContainer();
        return self;
    }

    public XContainer() {
        XUtil.writeToLog("Start XContainer without Model");
    }

    public XContainer(Amalthea model) {
        this.prepare(model);
    }

    public void prepare(Amalthea model) {
        XUtil.writeToLog("######################" + new Date().toLocaleString() + "########################");
        this.globalChain = new LinkedList();
        this.runnables = new HashMap();
        this.labels = new HashMap();
        this.cores = new HashMap();
        this.tasks = new HashMap();
        this.scheduler = new HashMap();
        this.chain = new HashMap();
        this.bLabelsNumCheckPassed = false;
        this.bRunnableNumCheckPassed = false;
        this.bCoreNumCheckPassed = false;
        this.bTaskNumCheckPassed = false;
        this.bSchedulerNumCheckPassed = false;
        this.haveglobal = false;
        try {
            this.addLabel(model);
            this.addRunnables(model);
            this.addCores(model);
            this.addTasks(model);
            if (this.bLabelsNumCheckPassed && this.bRunnableNumCheckPassed && this.bCoreNumCheckPassed && this.bTaskNumCheckPassed) {
                XMappingUtil.getScaduler(model.getMappingModel(), this.scheduler, this.cores);
                XMappingUtil.addTasks(model.getMappingModel(), this.scheduler, this.tasks);
                if (this.scheduler.size() > 0) {
                    this.bSchedulerNumCheckPassed = true;
                    this.linkUser();
                }
            }
            this.printStatistics();
        }
        catch (Exception e) {
            e.printStackTrace();
            XUtil.writeToLog("No Software Model defined");
            this.printStatistics();
        }
    }

    private void linkUser() {
        Iterator<String> it = this.scheduler.keySet().iterator();
        while (it.hasNext()) {
            XScheduler xx = this.scheduler.get(it.next());
            XMappingUtil.LinkTasks(xx);
            this.chain.put(xx.getCore().getName(), new XEventChain(xx));
        }
    }

    private void addCores(Amalthea model) {
        List lCores = HardwareUtil.getModulesFromHwModel(ProcessingUnitImpl.class, (Amalthea)model);
        for (ProcessingUnitImpl core : lCores) {
            this.cores.put(core.getName(), new XCore(core.getName()));
            if (this.cores.size() <= 0) continue;
            this.bCoreNumCheckPassed = true;
        }
    }

    private void addTasks(Amalthea model) {
        if (model != null) {
            EList pp = model.getSwModel().getTasks();
            for (Task tmp : pp) {
                List list = SoftwareUtil.getRunnableList((Process)tmp, null);
                Iterator iterator = list.iterator();
                XTasks xT = new XTasks(tmp);
                while (iterator.hasNext()) {
                    Runnable run = (Runnable)iterator.next();
                    xT.addRunnable(run.getName(), this.runnables.get(run.getName()));
                }
                this.tasks.put(tmp.getName(), xT);
                for (String runer : xT.getMap().keySet()) {
                    xT.getMap().get(runer).setTask(xT);
                }
            }
            if (this.tasks.size() > 1) {
                this.bTaskNumCheckPassed = true;
            }
        }
    }

    private void addLabel(Amalthea model) {
        if (model != null) {
            EList pp = model.getSwModel().getLabels();
            for (Label tmp : pp) {
                this.labels.put(tmp.getName(), new XLabel(tmp));
            }
            if (this.labels.size() > 0) {
                this.bLabelsNumCheckPassed = true;
            }
        }
    }

    private void addGlobalChains(Amalthea model) {
        if (model.getConstraintsModel() == null) {
            return;
        }
        if (model.getConstraintsModel().getEventChains().size() > 0) {
            this.haveglobal = true;
            for (EventChain ec : model.getConstraintsModel().getEventChains()) {
                this.globalChain.add(new LinkedList());
                ec.getItems().forEach((Consumer)new Consumer<EventChainItem>(){

                    @Override
                    public void accept(EventChainItem eventChainItem) {
                        ((LinkedList)XContainer.this.globalChain.getLast()).add(new ChainElement((XLabel)XContainer.this.labels.get(eventChainItem.getEventChain().getName().substring(3))));
                    }
                });
            }
            this.globalChain.forEach(xLabels -> xLabels.forEach(label -> {}));
        }
    }

    private void addRunnables(Amalthea model) {
        if (model != null) {
            this.addGlobalChains(model);
            EList pp = model.getSwModel().getRunnables();
            for (Runnable run : pp) {
                XRunnable XRun = new XRunnable(run);
                for (LabelAccess xL : SoftwareUtil.getLabelAccessList((Runnable)run, null)) {
                    if (this.labels.size() <= 0) continue;
                    XAccess cici = null;
                    cici = xL.getAccess().getName().compareTo("write") == 0 ? XRun.addAccess(1, this.labels.get(xL.getData().getName())) : XRun.addAccess(0, this.labels.get(xL.getData().getName()));
                    for (LinkedList linkedList : this.globalChain) {
                        for (ChainElement ce : linkedList) {
                            ce.saveAdd(XRun, cici);
                        }
                    }
                }
                this.runnables.put(run.getName(), XRun);
            }
            if (this.runnables.size() > 0) {
                this.bRunnableNumCheckPassed = true;
            }
        }
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder();
        this.p1(sb);
        this.p2(sb);
        int c = 1;
        for (LinkedList linkedList : this.globalChain) {
            sb.append("# Chain " + c + "\n");
            for (ChainElement element : linkedList) {
                sb.append(String.valueOf(element.toString()) + "\n");
            }
            c = (short)(c + 1);
        }
        XUtil.writeToLog(sb.toString());
        System.out.println(sb);
        return sb.toString();
    }

    private void p1(StringBuilder sb) {
        sb.append("#### XContainer - Level I - Statistic ####\n");
        sb.append("#           TOTAL\n");
        sb.append("#\n");
        sb.append("#    Cores: ");
        sb.append(this.cores.size());
        sb.append("\n");
        sb.append("#    Tasks: ");
        sb.append(this.tasks.size());
        sb.append("\n");
        sb.append("#    Runables: ");
        sb.append(this.runnables.size());
        sb.append("\n");
        sb.append("#    Label: ");
        sb.append(this.labels.size());
        sb.append("\n");
    }

    private void p2(StringBuilder sb) {
        Iterator<String> it;
        sb.append("#### XContainer - Level II - Statistic ####\n");
        sb.append("#           TOTAL\n");
        sb.append("#\n");
        sb.append("#    Scheduler: ");
        sb.append(this.scheduler.size());
        sb.append("\n");
        if (this.scheduler.size() > 0) {
            it = this.scheduler.keySet().iterator();
            while (it.hasNext()) {
                XScheduler xS = this.scheduler.get(it.next());
                sb.append("#    " + xS.getName() + ": " + xS.size() + "\n");
            }
        }
        sb.append("#\n");
        sb.append("#    Tasks: ");
        sb.append(this.tasks.size());
        sb.append("\n");
        if (this.tasks.size() > 0) {
            it = this.tasks.keySet().iterator();
            while (it.hasNext()) {
                XTasks xT = this.tasks.get(it.next());
                sb.append("#    " + xT.getName() + ": " + xT.size() + " l:" + xT.getConsumer().size() + "\n");
            }
        }
        sb.append("#\n");
        sb.append("#    Runnable: ");
        sb.append(this.runnables.size());
        sb.append("\n");
        int countRead = 0;
        int coundWrite = 0;
        if (this.runnables.size() > 0) {
            Iterator<String> it2 = this.runnables.keySet().iterator();
            while (it2.hasNext()) {
                XRunnable xR = this.runnables.get(it2.next());
                Iterator<XAccess> itt = xR.getList().iterator();
                while (itt.hasNext()) {
                    if (itt.next().getState() == 0) {
                        ++countRead;
                        continue;
                    }
                    ++coundWrite;
                }
            }
        }
        sb.append("#   AccessCount read:" + countRead + " write:" + coundWrite);
        sb.append("\n");
        sb.append("#" + this.validateExecutableString() + "\n");
    }

    private String validateExecutableString() {
        if (this.bLabelsNumCheckPassed && this.bRunnableNumCheckPassed && this.bCoreNumCheckPassed && this.bTaskNumCheckPassed && this.bSchedulerNumCheckPassed) {
            return "Checks passed, ready for Visualization";
        }
        return String.format("Some checks failed: Labels %b, Runnables %b, Cores %b, Tasks %b, Schedulers %b", this.bLabelsNumCheckPassed, this.bRunnableNumCheckPassed, this.bCoreNumCheckPassed, this.bTaskNumCheckPassed, this.bSchedulerNumCheckPassed);
    }

    public XEventChain getChainByCore(String core) {
        return this.chain.get(core);
    }

    public XEventElement addtoChainByCore(String taskName, String core, int status, long start, double duration) {
        if (this.chain.get(core) != null && this.tasks.get(taskName) != null) {
            XEventChain cc = this.chain.get(core);
            if (status == 0) {
                XEventElement element = new XEventElement(taskName, this.tasks.get(taskName), true, status, start, duration);
                cc.betterAdd(element);
                return element;
            }
            XEventElement element = new XEventElement(taskName, this.tasks.get(taskName), false, status, start, duration);
            cc.betterAdd(element);
            return element;
        }
        System.err.println("LINKING ERROR");
        return null;
    }

    public boolean validateExecutable() {
        return this.bLabelsNumCheckPassed && this.bRunnableNumCheckPassed && this.bCoreNumCheckPassed && this.bTaskNumCheckPassed && this.bSchedulerNumCheckPassed;
    }

    public HashMap<String, XScheduler> getScheduler() {
        return this.scheduler;
    }

    public HashMap<String, XCore> getCores() {
        return this.cores;
    }

    public HashMap<String, XTasks> getTasks() {
        return this.tasks;
    }

    public boolean isLabelView() {
        return this.labelView;
    }

    public void setLabelView(boolean labelView) {
        this.labelView = labelView;
    }

    public boolean isDataFlow() {
        return this.dataFlow;
    }

    public void setDataFlow(boolean dataFlow) {
        this.dataFlow = dataFlow;
    }

    public boolean isMergingArrow() {
        return this.mergingArrow;
    }

    public void setMergingArrow(boolean value) {
        this.mergingArrow = value;
    }

    public boolean isAlternativeArrow() {
        return this.alternativeArrow;
    }

    public void setAlternativeArrow(boolean value) {
        this.alternativeArrow = value;
    }

    public String getReport() {
        this.sb = new StringBuilder();
        for (String sel : this.chain.keySet()) {
            if (sel != null) {
                int r = 0;
                Iterator it = this.chain.get(sel).iterator();
                while (it.hasNext()) {
                    if (((XEventElement)it.next()).getStatus() != 0) continue;
                    ++r;
                }
                this.sb.append("\n" + sel + "\n" + "Total Tasks Complete: " + r + "\n");
                continue;
            }
            return this.sb.toString();
        }
        return this.sb.toString();
    }

    public LinkedList<LinkedList<ChainElement>> getGlobalChain() {
        return this.globalChain;
    }

    public HashMap<String, XRunnable> getRunnables() {
        return this.runnables;
    }

    public HashMap<String, XLabel> getLabels() {
        return this.labels;
    }

    public HashMap<String, XEventChain> getChain() {
        return this.chain;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public Object[][] generateReport() throws NullPointerException {
        int refactor = 1;
        int width = 4;
        this.cores.size();
        Object[][] out = new Object[this.cores.size() * refactor][width];
        Iterator<String> it = this.scheduler.keySet().iterator();
        int i = 0;
        while (i + refactor - 1 < out.length) {
            XScheduler sc = this.scheduler.get(it.next());
            XEventChain cc = this.getChainByCore(sc.getCore().getName());
            int countRun = 0;
            int countOver = 0;
            int countUnde = 0;
            for (XTasks tas : sc.getTasks()) {
                for (XEventElement zzmp : cc.getFullList(tas.getName())) {
                    MultysamplingViewElement mmb;
                    AbstractGanttViewElement agv = zzmp.getAbstractGanttViewElement();
                    if (zzmp.getStatus() == 0) {
                        ++countRun;
                    }
                    if (!(agv instanceof MultysamplingViewElement) || !(mmb = (MultysamplingViewElement)agv).isCountable()) continue;
                    if (mmb.isOverSampling()) {
                        ++countOver;
                    }
                    if (!mmb.isUnderSampling()) continue;
                    ++countUnde;
                }
            }
            out[i] = new Object[]{sc.getCore().getName(), countRun, countOver, countUnde};
            i += refactor;
        }
        return out;
    }

    public XResult getLabelAcces(String sel, String core) {
        XTasks tmpTask = this.getTasks().get(sel);
        long read = 0L;
        long write = 0L;
        long count = 0L;
        for (String curRun : tmpTask.getMap().keySet()) {
            for (XAccess access : tmpTask.getMap().get(curRun).getList()) {
                switch (access.getState()) {
                    case 0: {
                        ++read;
                        break;
                    }
                    case 1: {
                        ++write;
                    }
                }
            }
        }
        for (XEventElement xEl : this.getChainByCore(core).getFullList(sel)) {
            MultysamplingViewElement el;
            if (!(xEl.getAbstractGanttViewElement() instanceof MultysamplingViewElement) || !(el = (MultysamplingViewElement)xEl.getAbstractGanttViewElement()).isCountable() || xEl.getStatus() != 1) continue;
            ++count;
        }
        return new XResult(read * count, write * count);
    }

    public boolean isHaveglobal() {
        return this.haveglobal;
    }

    public static class ChainElement {
        XLabel label;
        LinkedList<XRunnable> read;
        LinkedList<XRunnable> write;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n##########" + this.label.getName() + "#########\n");
            sb.append("#\n");
            for (XRunnable run : this.write) {
                if (run.getTask() != null) {
                    sb.append("#w " + run.getTask().getName() + " - " + run.getName() + " \n");
                    continue;
                }
                sb.append("#w error");
            }
            for (XRunnable run : this.read) {
                if (run.getTask() != null) {
                    sb.append("#r " + run.getTask().getName() + " - " + run.getName() + " \n");
                    continue;
                }
                sb.append("#r error");
            }
            return sb.toString();
        }

        public void saveAdd(XRunnable cc, XAccess inpu) {
            if (inpu.getLabel().equals(this.label)) {
                if (inpu.getState() == 0) {
                    this.read.add(cc);
                } else if (inpu.getState() == 1) {
                    this.write.add(cc);
                }
            }
        }

        public void printElement() {
            System.out.print(this.toString());
        }

        public ChainElement(XLabel label) {
            this.label = label;
            this.read = new LinkedList();
            this.write = new LinkedList();
        }

        public XLabel getLabel() {
            return this.label;
        }

        public LinkedList<XRunnable> getRead() {
            return this.read;
        }

        public void setRead(LinkedList<XRunnable> read) {
            this.read = read;
        }

        public LinkedList<XRunnable> getWrite() {
            return this.write;
        }

        public void setWrite(LinkedList<XRunnable> write) {
            this.write = write;
        }
    }

    public class XResult {
        long read;
        long write;

        public XResult(long read, long write) {
            this.read = read;
            this.write = write;
        }

        public long getRead() {
            return this.read;
        }

        public long getWrite() {
            return this.write;
        }
    }
}

