/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JFileChooser;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaLoader;
import org.eclipse.app4mc.multicore.execution.ui.widget.comunication.ComUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XContainer;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XAccess;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventChain;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XRunnable;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XScheduler;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XTasks;

public class XUtil {
    private final boolean debuger = false;
    private final StringBuilder sb = new StringBuilder();

    public static XContainer startWithInput(int sel, String path) {
        switch (sel) {
            case 0: {
                XUtil x = new XUtil();
                return x.openWithUI();
            }
            case 1: {
                XUtil x = new XUtil();
                return x.t1(path);
            }
        }
        return null;
    }

    public static XScheduler getSchedulerByCore(XContainer xContainer, String core) {
        HashMap<String, XScheduler> map = xContainer.getScheduler();
        for (String sc : map.keySet()) {
            if (map.get(sc).getCore().getName().compareTo(core) != 0) continue;
            return map.get(sc);
        }
        return null;
    }

    public static boolean hasDepended(String task, XScheduler tmp) {
        if (!XContainer.getInstance(null).isDataFlow()) {
            return false;
        }
        for (XTasks t : tmp.getTasks()) {
            if (t.getName().compareTo(task) != 0) continue;
            return t.getProducer().size() > 0;
        }
        return false;
    }

    public static LinkedList<ComUtil.ULabel> getAllLabels(XContainer xContainer) {
        LinkedList<ComUtil.ULabel> out = new LinkedList<ComUtil.ULabel>();
        HashMap<String, XTasks> tasks = xContainer.getTasks();
        HashMap<String, XRunnable> runnable = xContainer.getRunnables();
        String tmpTask = "";
        String tmpRun = "";
        Iterator<String> iterator = tasks.keySet().iterator();
        while (iterator.hasNext()) {
            String nt;
            tmpTask = nt = iterator.next();
            Iterator<String> iterator2 = tasks.get(nt).getMap().keySet().iterator();
            while (iterator2.hasNext()) {
                String nr;
                tmpRun = nr = iterator2.next();
                for (XAccess acc : runnable.get(nr).getList()) {
                    out.add(new ComUtil.ULabel(acc.getLabel().getName(), tmpRun, tmpTask));
                }
            }
        }
        return out;
    }

    public static ResultObj isAffected(XEventChain chainByCore, String task) {
        Iterator<XEventElement> it;
        StringBuilder sb = new StringBuilder();
        ResultObj out = new ResultObj();
        out.setState(0);
        if (!XContainer.getInstance(null).isDataFlow()) {
            out.setState(-300);
            return out;
        }
        LinkedList<XEventElement> tmplist = XUtil.getFilteredList(chainByCore, task);
        if (tmplist.size() > 1 && (it = tmplist.descendingIterator()).next().getStatus() == 2 && it.next().getStatus() == 1) {
            out.setState(0);
            return out;
        }
        for (XTasks t : chainByCore.getScheduler().getTasks()) {
            if (t.getName().compareTo(task) != 0) continue;
            if (t.getProducer().isEmpty()) {
                out.setState(0);
                return out;
            }
            sb.append("#########################" + t.getName() + "################################");
            sb.append("\n");
            out = XUtil.isInFinishList(chainByCore, t, sb);
            sb.append("######################### End ################################");
            sb.append("\n");
            return out;
        }
        return out;
    }

    private static ResultObj isInFinishList(XEventChain cbc, XTasks linked, StringBuilder sb) {
        Iterator<String> it = linked.getProducer().keySet().iterator();
        ResultObj out = new ResultObj();
        out.setState(0);
        int count = 0;
        block0: while (it.hasNext()) {
            count = 0;
            XEntry currentOutput = null;
            XTasks tmpTask = linked.getProducer().get(it.next());
            sb.append("#");
            sb.append("\n");
            sb.append("# Search for " + tmpTask.getName());
            sb.append("\n");
            Iterator<XEventElement> itt = XUtil.getFilteredList(cbc, tmpTask.getName()).descendingIterator();
            while (itt.hasNext()) {
                XEventElement eventElement = itt.next();
                sb.append("# Compare with ->" + eventElement.getName() + "\n");
                sb.append("\n # @ " + eventElement.getStart() + "\n # for " + eventElement.getDuration());
                sb.append("# Status->" + eventElement.getStatus() + "\n");
                if (count == 0 && eventElement.getStatus() == 1) {
                    sb.append("## Found Prommise at " + count + "\n");
                    sb.append("##> " + eventElement.getStart() + "\n");
                    sb.append("#");
                    sb.append("\n");
                    currentOutput = new XEntry(eventElement, -1);
                    out.push(currentOutput);
                    out.setHavePrommise(true);
                }
                if (eventElement.getStatus() == 0) {
                    sb.append("## Found Match at " + count + "\n");
                    sb.append("##> " + eventElement.getStart() + "\n");
                    sb.append("#");
                    sb.append("\n");
                    if (currentOutput != null) {
                        currentOutput.setPromiseAlternative(new XEntry(eventElement, 1));
                        out.push(currentOutput);
                        continue block0;
                    }
                    out.setState(1);
                    out.push(new XEntry(eventElement, 1));
                    ++count;
                    continue block0;
                }
                ++count;
            }
        }
        if (out.getState() == 0) {
            sb.append("## Found no Match \n");
        } else {
            sb.append("## Found " + out.size() + " Match(s) \n");
        }
        return out;
    }

    public static LinkedList<String> getAffected(XEventChain ec, String task1) {
        LinkedList<String> out = new LinkedList<String>();
        for (XTasks t : ec.getScheduler().getTasks()) {
            if (t.getName().compareTo(task1) != 0) continue;
            if (t.getProducer().isEmpty()) {
                return out;
            }
            ArrayList<String> ttmp = XUtil.getInFinishList(ec, t.getProducer());
            for (String s : ttmp) {
                out.add(s);
            }
        }
        return out;
    }

    private static ArrayList<String> getInFinishList(XEventChain cbc, HashMap<String, XTasks> linked) {
        ArrayList<String> outPut = new ArrayList<String>();
        Iterator<String> it = linked.keySet().iterator();
        while (it.hasNext()) {
            XTasks tmpTask = linked.get(it.next());
            for (XEventElement s : cbc) {
                if (s.getName().compareTo(tmpTask.getName()) != 0) continue;
                outPut.add(s.getName());
            }
        }
        return outPut;
    }

    private XContainer openWithUI() {
        JFileChooser chooser = new JFileChooser("Please set Amalthea Model");
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(2);
        File file = new File("/");
        chooser.setCurrentDirectory(file);
        chooser.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("SelectedFileChangedProperty") || e.getPropertyName().equals("directoryChanged")) {
                File cfr_ignored_0 = (File)e.getNewValue();
            }
        });
        chooser.setVisible(true);
        int result = chooser.showOpenDialog(null);
        if (result == 0) {
            File inputVerzFile = chooser.getSelectedFile();
            String inputVerzStr = inputVerzFile.getPath();
            return this.t1(inputVerzStr);
        }
        chooser.setVisible(false);
        return null;
    }

    private XContainer t1(String path) {
        XContainer c = null;
        try {
            File inputFile = new File(path);
            Amalthea model = AmaltheaLoader.loadFromFile((File)inputFile);
            if (model == null) {
                XUtil.writeToLog("Error: No model loaded!");
            }
            c = XContainer.getInstance(null);
            c.prepare(model);
        }
        catch (Exception e) {
            System.out.println("Error while loading Amalthea Model");
            System.out.println("#########################################");
            System.out.println(e.toString());
            System.out.println("#########################################");
        }
        return c;
    }

    private void runFull(XContainer c) {
        this.sb.append("###########Detail Scaduling info ################\n");
        if (c.validateExecutable()) {
            Set<String> keySet = c.getScheduler().keySet();
            Iterator<String> it = keySet.iterator();
            while (it.hasNext()) {
                XScheduler s = c.getScheduler().get(it.next());
                this.sb.append("\n# Name: ");
                this.sb.append(String.valueOf(s.getName()) + "\n");
                this.level00(s);
            }
        }
    }

    private void level00(XScheduler s) {
        this.level01(s);
    }

    private void level01(XScheduler s) {
        this.sb.append("# CPU: " + s.getCore().getName() + "\n");
        List<XTasks> list = s.getTasks();
        this.level02(list);
    }

    private void level02(List<XTasks> list) {
        for (XTasks tmp : list) {
            this.sb.append("\n## Task: " + tmp.getName() + "\n");
            this.level03(tmp);
        }
    }

    private void level03(XTasks t) {
        HashMap<String, XRunnable> map = t.getMap();
        Iterator<String> keys = map.keySet().iterator();
        LinkedList<XAccess> read = new LinkedList<XAccess>();
        LinkedList<XAccess> write = new LinkedList<XAccess>();
        while (keys.hasNext()) {
            XRunnable tmp = map.get(keys.next());
            for (XAccess aTmp : tmp.getList()) {
                switch (aTmp.getState()) {
                    case 0: {
                        read.add(aTmp);
                        break;
                    }
                    case 1: {
                        write.add(aTmp);
                        break;
                    }
                }
            }
        }
        this.sb.append("#### Read: " + read.size() + " Write: " + write.size() + "\n");
    }

    public static boolean se(XTasks t, Iterable<XTasks> iterable) {
        boolean output = false;
        List<XAccess> toCompaer = t.getBySel(0);
        for (XTasks x : iterable) {
            output = XUtil.compareAccess(toCompaer, x.getBySel(1));
            if (!output) continue;
            t.addProducer(x);
            output = true;
        }
        return output;
    }

    public static boolean compareAccess(Iterable<XAccess> first, Iterable<XAccess> next) {
        Iterator<XAccess> it1 = first.iterator();
        while (it1.hasNext()) {
            Iterator<XAccess> it2 = next.iterator();
            XAccess tmp1 = it1.next();
            while (it2.hasNext()) {
                XAccess tmp2 = it2.next();
                if (tmp1.getLabel().getName().compareTo(tmp2.getLabel().getName()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String compareTasks(XTasks read, XTasks write) {
        String out = "";
        for (XAccess tmpA : read.getBySel(0)) {
            for (XAccess tmpB : write.getBySel(1)) {
                if (tmpA.getLabel().getName().compareTo(tmpB.getLabel().getName()) != 0) continue;
                out = String.valueOf(out) + tmpA.getLabel().getName() + ",";
            }
        }
        return out;
    }

    public static LinkedList<XEventElement> getFilteredList(XEventChain chain, String name) {
        LinkedList<XEventElement> output = new LinkedList<XEventElement>();
        for (XEventElement tmp : chain) {
            if (tmp.getName().compareTo(name) != 0) continue;
            output.add(tmp);
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeToLog(String inString) {
        File f = new File("log.txt");
        boolean existsFlag = f.exists();
        if (!existsFlag) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println("could not create new log file");
                System.out.println(inString);
                return;
            }
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileWriter fstream = new FileWriter(f, true);
                try {
                    try (BufferedWriter out = new BufferedWriter(fstream);){
                        out.write(String.valueOf(inString) + "\n");
                        out.newLine();
                    }
                    if (fstream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fstream == null) throw throwable;
                    fstream.close();
                    throw throwable;
                }
                fstream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("could not write to the file");
            e.printStackTrace();
        }
    }

    public static class ResultObj
    extends Stack<XEntry> {
        private static final long serialVersionUID = 7182159430688964140L;
        int state = -2;
        boolean havePrommise = false;

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public boolean isHavePrommise() {
            return this.havePrommise;
        }

        public void setHavePrommise(boolean havePrommise) {
            this.havePrommise = havePrommise;
        }
    }

    public static class XEntry {
        XEventElement el;
        XEntry promiseAlternative;
        int state;

        public XEntry(XEventElement el, int state) {
            this.el = el;
            this.state = state;
            this.promiseAlternative = null;
        }

        public XEventElement getEl() {
            return this.el;
        }

        public int getState() {
            return this.state;
        }

        public boolean havePromiseAlternative() {
            return this.promiseAlternative != null;
        }

        public XEntry getPromiseAlternative() {
            return this.promiseAlternative;
        }

        public void setPromiseAlternative(XEntry promiseAlternative) {
            this.promiseAlternative = promiseAlternative;
        }
    }
}

