/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.ui.widget.comunication.ComUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ArrowElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ArrowTimeMarkerViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DataFlowArrowViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DataFlowArrowViewElementAlternative;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DurationModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.FlashTimeMarkerViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.MultysamplingViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ProgressViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.TimeMarkModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.misc.FXUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XContainer;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventChain;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XEventElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XScheduler;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.ITraceWidget;

public class TraceWidget
extends GridPane
implements ITraceWidget {
    XContainer xContainer;
    private Map<String, ListView> listView;
    private Button globalButton;
    private Button chainButton;
    String listViewItem;
    HashMap<String, Stack<Promise>> promissList = new HashMap();
    private ExecutionModel em;
    private Map<String, Core> cores;
    private CheckBox cbScrollAllCharts;
    private Queue<QueueData> queue = new ConcurrentLinkedQueue<QueueData>();
    private int row = 0;
    private String axisLabel = "";

    public TraceWidget() {
        this.cores = new HashMap<String, Core>();
        this.listView = new HashMap<String, ListView>();
        this.setupPane();
        this.initDataPopulation();
    }

    public void setExMod(ExecutionModel em) {
        this.em = em;
    }

    private void setupPane() {
        ColumnConstraints column = new ColumnConstraints();
        column.setPercentWidth(10.0);
        this.getColumnConstraints().add((Object)column);
        column = new ColumnConstraints();
        column.setPercentWidth(90.0);
        this.getColumnConstraints().add((Object)column);
        this.setVgap(10.0);
        this.globalButton = new Button();
        this.globalButton.setPadding(new Insets(5.0));
        this.globalButton.setText("\ud83c\udf10");
        this.globalButton.setPrefHeight(this.globalButton.getHeight() * 0.8);
        this.globalButton.setDisable(true);
        this.globalButton.setVisible(false);
        this.globalButton.setOnMouseClicked(event -> ComUtil.showGlobalChains(this.xContainer));
        this.chainButton = new Button();
        this.chainButton.setPadding(new Insets(5.0));
        this.chainButton.setText("\u26d3");
        this.chainButton.setPrefHeight(this.globalButton.getHeight() * 0.8);
        this.chainButton.setDisable(true);
        this.chainButton.setVisible(false);
        this.chainButton.setOnMouseClicked(event -> ComUtil.showAllChains(this.xContainer));
        this.cbScrollAllCharts = new CheckBox("Scroll all charts");
        this.cbScrollAllCharts.setVisible(false);
        this.add((Node)this.cbScrollAllCharts, 1, this.row);
        this.add((Node)new HBox(new Node[]{this.chainButton, this.globalButton}), 0, this.row);
        ++this.row;
        GridPane.setColumnSpan((Node)this.cbScrollAllCharts, (Integer)1);
        this.cbScrollAllCharts.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                for (Core c1 : this.cores.values()) {
                    for (Core c21 : this.cores.values()) {
                        if (c1 == c21) continue;
                        c1.chart.getNumberAxis().lowerBoundProperty().bindBidirectional((Property)c21.chart.getNumberAxis().lowerBoundProperty());
                        c1.chart.getNumberAxis().upperBoundProperty().bindBidirectional((Property)c21.chart.getNumberAxis().upperBoundProperty());
                    }
                }
            } else {
                for (Core c3 : this.cores.values()) {
                    for (Core c22 : this.cores.values()) {
                        if (c3 == c22) continue;
                        c3.chart.getNumberAxis().lowerBoundProperty().unbindBidirectional((Property)c22.chart.getNumberAxis().lowerBoundProperty());
                        c3.chart.getNumberAxis().upperBoundProperty().unbindBidirectional((Property)c22.chart.getNumberAxis().upperBoundProperty());
                    }
                }
            }
        });
    }

    @Override
    public void addTask(String core, final String task) {
        final Core c = this.cores.get(core);
        if (c == null) {
            return;
        }
        if (c.tasks.contains(task)) {
            return;
        }
        if (core.compareTo("Core") != 0) {
            this.xContainer.getChainByCore(core).addSort(task);
        }
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    c.chart.addCategorie(task);
                    c.tasks.add(task);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTaskRunning(String core, String task, long start, long stop) {
        double duration = (double)stop - (double)start;
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        XScheduler tmp = XUtil.getSchedulerByCore(this.xContainer, core);
        DurationModelElement tmElemnet = new DurationModelElement(start, duration, "running");
        if (XUtil.hasDepended(task, tmp)) {
            XUtil.ResultObj tmpEff = XUtil.isAffected(this.xContainer.getChainByCore(core), task);
            this.addTaskEffect(c, task, tmpEff, 0, start, tmElemnet);
        } else if (this.xContainer.isMergingArrow()) {
            this.addTaskEffect(c, task, null, 0, start, tmElemnet);
        } else {
            this.addToFXQueue(c, task, start, new ProgressViewElement("status-light-green", new DurationModelElement(start, duration, "running")));
        }
        this.solveAllPromise("run", task);
        this.addToFXQueue(c, "Core", start, new ProgressViewElement("status-green", new DurationModelElement(start, duration, "")));
    }

    @Override
    public void addTaskWaiting(String core, String task, String note, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c, task, start, new ProgressViewElement("status-orange", new DurationModelElement(start, (double)stop - (double)start, "waiting\n" + note)));
    }

    @Override
    public void addTaskActivation(String core, String task, long time) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c, task, time, new ArrowTimeMarkerViewElement("activate", new TimeMarkModelElement(time, "")));
    }

    @Override
    public void addTaskEffect(Core core, String task1, XUtil.ResultObj list, int offsetX, long time, DurationModelElement element) {
        XEventElement ttmp;
        Iterator<XEventElement> it;
        XEventChain ec = this.xContainer.getChainByCore(core.name);
        MultysamplingViewElement outPutBox = new MultysamplingViewElement(this.xContainer.getTasks().get(task1), "status-light-green", element, this.xContainer.isMergingArrow(), core.name, ec);
        if (!this.cores.containsKey(core.name)) {
            return;
        }
        if (!this.cores.get((Object)core.name).tasks.contains(task1)) {
            return;
        }
        Core c = this.cores.get(core.name);
        String affected = outPutBox.getAffected();
        while (list != null && !list.isEmpty()) {
            XUtil.XEntry curer = (XUtil.XEntry)list.pop();
            if (curer.getState() == 1) {
                affected = String.valueOf(affected) + curer.getEl().getName() + "[ true ]\n";
                this.addDependecyArrow(c, task1, curer, time, ec, outPutBox, false);
                continue;
            }
            if (curer.getState() != -1) continue;
            affected = String.valueOf(affected) + curer.getEl().getName() + "[ Promise ]\n";
            this.addPromise(new ArrowPromise(c, task1, list, offsetX, time, element, curer, ec, outPutBox));
        }
        element.setLabel(affected);
        if (ec.getFullList(task1).size() > 1 && (it = ec.getFullList(task1).descendingIterator()).next().getStatus() == 2 && (ttmp = it.next()).getStatus() == 1) {
            outPutBox.mergeMe((MultysamplingViewElement)ttmp.getAbstractGanttViewElement(), true);
            outPutBox.diableCount();
        }
        this.addToFXQueue(core, task1, time, outPutBox);
    }

    private void addDependecyArrow(Core c, String task1, XUtil.XEntry curer, long time, XEventChain ec, MultysamplingViewElement outPutBox, boolean isPromise) {
        ArrowElement arrow;
        boolean sell;
        XEventElement haveToTell = null;
        Iterator<XEventElement> it = ec.getFullList(curer.getEl().getTasks().getName()).descendingIterator();
        block0: while (this.xContainer.isMergingArrow() && it.hasNext()) {
            haveToTell = it.next();
            if ((double)haveToTell.getStart() + haveToTell.getDuration() == (double)curer.getEl().getStart()) {
                if (haveToTell.getAbstractGanttViewElement() instanceof MultysamplingViewElement && ((MultysamplingViewElement)haveToTell.getAbstractGanttViewElement()).isCountable()) break;
                while (it.hasNext()) {
                    haveToTell = it.next();
                    if (haveToTell.getAbstractGanttViewElement() instanceof MultysamplingViewElement && ((MultysamplingViewElement)haveToTell.getAbstractGanttViewElement()).isCountable()) break block0;
                    if (haveToTell.getStatus() != 0) continue;
                    haveToTell = null;
                    break block0;
                }
                break;
            }
            haveToTell = null;
        }
        if (this.xContainer.isMergingArrow() && haveToTell != null) {
            ((MultysamplingViewElement)haveToTell.getAbstractGanttViewElement()).tellProducer(task1, time);
        }
        long ofsE = time;
        long ofsS = curer.getEl().getStart();
        long cals = ofsE - ofsS;
        boolean oversamp = false;
        if (outPutBox.contains(curer.getEl().getName())) {
            return;
        }
        XUtil.writeToLog("Add Task Effect  from " + task1 + " to  " + curer.getEl().getName() + " " + ofsE + " " + ofsS + " = " + cals + "\nTime=> " + time);
        String label = "";
        label = XUtil.compareTasks(this.xContainer.getTasks().get(task1), this.xContainer.getTasks().get(curer.getEl().getName()));
        if (isPromise) {
            sell = outPutBox.isMergeArrow() && ec.getLastPrmFinish(curer.getEl().getName()) != null && ec.getLastPrmFinish(curer.getEl().getName()).getStart() == curer.getEl().getStart();
        } else {
            boolean bl = sell = outPutBox.isMergeArrow() && ec.getLastFinish(curer.getEl().getName()) != null && ec.getLastFinish(curer.getEl().getName()).getStart() == curer.getEl().getStart();
        }
        if (sell) {
            oversamp = true;
            arrow = new DataFlowArrowViewElement("activate", ec.getIndexOf(task1), ec.getIndexOf(curer.getEl().getName()), cals, new ArrowTooltip(task1, curer.getEl().getName(), ofsS, cals, label));
            ec.addReplaceFinish(curer.getEl());
        } else {
            if (this.xContainer.isAlternativeArrow()) {
                arrow = new DataFlowArrowViewElementAlternative("activate", ec.getIndexOf(task1), ec.getIndexOf(curer.getEl().getName()), cals, new ArrowTooltip(task1, curer.getEl().getName(), ofsS, cals, label));
                this.addToFXQueue(c, task1, time, arrow);
                arrow.toFront();
            } else {
                arrow = new DataFlowArrowViewElement("activate", ec.getIndexOf(task1), ec.getIndexOf(curer.getEl().getName()), cals, new ArrowTooltip(task1, curer.getEl().getName(), ofsS, cals, label));
                this.addToFXQueue(c, task1, time, arrow);
                arrow.toFront();
            }
            ec.addReplaceFinish(curer.getEl());
        }
        outPutBox.addArrow(arrow);
        if (oversamp) {
            outPutBox.setOverSampling(curer.getEl().getName());
        }
    }

    @Override
    public void addTaskEffectFollow(String core, String task1, long start, long end, long time) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task1)) {
            return;
        }
        this.cores.get(core);
        XEventChain ec = this.xContainer.getChainByCore(core);
        Iterator<XEventElement> it = XUtil.getFilteredList(ec, task1).descendingIterator();
        if (XUtil.hasDepended(task1, ec.getScheduler()) && it.hasNext()) {
            XEventElement tmp = it.next();
            if (it.hasNext()) {
                tmp = it.next();
                switch (tmp.getStatus()) {
                    case 1: {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void addTaskReady(String core, String task, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c, task, start, new ProgressViewElement("status-yellow", new DurationModelElement(start, (double)stop - (double)start, "ready")));
        this.solveAllPromise("Ready", task);
    }

    @Override
    public void addTaskSuspended(String core, String task, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c, task, start, new ProgressViewElement("status-red", new DurationModelElement(start, (double)stop - (double)start, "suspended")));
        this.solveAllPromise("Suspend", task);
    }

    @Override
    public void addTaskDeadlineMissed(String core, String task, long time) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        System.err.println("addTaskDeadlineMissed");
        Core c = this.cores.get(core);
        this.addToFXQueue(c, task, time, new FlashTimeMarkerViewElement("", new TimeMarkModelElement(time, "deadline missed")));
    }

    public void setAxisLabels(String label) {
        this.axisLabel = label;
        for (Core c : this.cores.values()) {
            c.chart.getNumberAxis().setLabel(label);
        }
    }

    @Override
    public void addCore(String core) {
        if (!this.cbScrollAllCharts.isVisible()) {
            Tooltip t;
            this.cbScrollAllCharts.setVisible(true);
            if (this.xContainer.isDataFlow()) {
                this.globalButton.setVisible(true);
                this.chainButton.setVisible(true);
                this.chainButton.setDisable(false);
                t = new Tooltip("Simulate custom event chains");
                Tooltip.install((Node)this.chainButton, (Tooltip)t);
            }
            if (this.xContainer.isHaveglobal()) {
                this.globalButton.setDisable(false);
                t = new Tooltip("Show global event chains");
                Tooltip.install((Node)this.globalButton, (Tooltip)t);
            } else {
                t = new Tooltip("No global event chains");
                Tooltip.install((Node)this.globalButton, (Tooltip)t);
            }
        }
        final Core c = new Core();
        c.chart = new FXGanttWidget(30);
        c.chart.getStylesheets().add((Object)this.getClass().getResource("/icons/ganttchart.css").toExternalForm());
        c.chart.getNumberAxis().setLabel(this.axisLabel);
        c.tasks = new HashSet<String>();
        c.name = core;
        this.cores.put(core, c);
        c.chart.addCategorie("Core");
        c.nav = new VBox();
        StackPane sp = TraceWidget.createIcon(core, this.getClass().getResource("/icons/coreIcon.png").toExternalForm());
        sp.setStyle("-fx-border-color: white");
        if (this.xContainer.isDataFlow()) {
            Tooltip t = new Tooltip("Show Task Dependency's");
            Tooltip.install((Node)sp, (Tooltip)t);
            EventHandler eventHandlerButton01 = e -> ComUtil.ShowTaskDepend(core);
            EventHandler eventHandlerButton02 = e -> sp.setStyle("-fx-border-color: black");
            EventHandler eventHandlerButton03 = e -> sp.setStyle("-fx-border-color: white");
            sp.setPadding(new Insets(2.0));
            sp.addEventFilter(MouseEvent.MOUSE_CLICKED, eventHandlerButton01);
            sp.addEventFilter(MouseEvent.MOUSE_ENTERED, eventHandlerButton02);
            sp.addEventFilter(MouseEvent.MOUSE_EXITED, eventHandlerButton03);
            sp.setCursor(Cursor.HAND);
        }
        c.nav.getChildren().add((Object)sp);
        Region nav = TraceWidget.createNav(c.chart.getNumberAxis().lowerBoundProperty(), c.chart.getNumberAxis().upperBoundProperty());
        c.nav.getChildren().add((Object)nav);
        VBox.setMargin((Node)c.nav, (Insets)new Insets(10.0));
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    if (TraceWidget.this.xContainer == null || !TraceWidget.this.xContainer.validateExecutable()) {
                        throw new NullPointerException();
                    }
                    VBox vbox = new VBox(20.0, new Node[]{c.chart});
                    TraceWidget.this.add((Node)c.nav, 0, TraceWidget.this.row);
                    TraceWidget.this.add((Node)vbox, 1, TraceWidget.this.row);
                    TraceWidget traceWidget = TraceWidget.this;
                    traceWidget.row = traceWidget.row + 1;
                }
            });
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            e3.printStackTrace();
        }
    }

    private static Region createNav(DoubleProperty lower, DoubleProperty upper) {
        VBox navPane = new VBox();
        Text labLb = new Text("Lower Bound");
        navPane.getChildren().add((Object)labLb);
        TextField txtLowerBond = new TextField();
        navPane.getChildren().add((Object)txtLowerBond);
        txtLowerBond.textProperty().bindBidirectional((Property)lower, (StringConverter)new NumberStringConverter());
        Text labUb = new Text("Upper Bound");
        navPane.getChildren().add((Object)labUb);
        TextField txtUpperBond = new TextField();
        navPane.getChildren().add((Object)txtUpperBond);
        txtUpperBond.textProperty().bindBidirectional((Property)upper, (StringConverter)new NumberStringConverter());
        return navPane;
    }

    private static StackPane createIcon(String txt, String url) {
        StackPane sp = new StackPane();
        ImageView ic = new ImageView(url);
        ic.setPreserveRatio(true);
        ic.setFitHeight(100.0);
        sp.getChildren().add((Object)ic);
        sp.getChildren().add((Object)new Text(txt));
        return sp;
    }

    @Override
    public void reset() {
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    TraceWidget.this.cores.values().forEach(x -> {
                        TraceWidget.this.getChildren().remove((Object)x.chart);
                        TraceWidget.this.getChildren().remove((Object)x.nav);
                    });
                    TraceWidget.this.cores.clear();
                    TraceWidget.this.row = TraceWidget.this.getChildren().size();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void addToFXQueue(Core c, String categorie, long start, AbstractGanttViewElement v) {
        block19: {
            if (!(v instanceof ProgressViewElement) || !this.xContainer.isDataFlow()) break block19;
            ProgressViewElement pe = (ProgressViewElement)v;
            if (categorie.compareTo("Core") == 0) break block19;
            switch (pe.getGanttStyle()) {
                case "status-red": {
                    v.setRef(this.xContainer.addtoChainByCore(categorie, c.name, 0, pe.getModel().getStart(), pe.getModel().getDuration()));
                    break;
                }
                case "status-yellow": {
                    v.setRef(this.xContainer.addtoChainByCore(categorie, c.name, 2, pe.getModel().getStart(), pe.getModel().getDuration()));
                    break;
                }
                case "status-over": 
                case "status-light-green": 
                case "status-multi": 
                case "status-under": {
                    v.setRef(this.xContainer.addtoChainByCore(categorie, c.name, 1, pe.getModel().getStart(), pe.getModel().getDuration()));
                }
            }
        }
        QueueData d = new QueueData(c.chart, categorie, start, v);
        this.queue.add(d);
    }

    private void initDataPopulation() {
        new AnimationTimer(){

            public void handle(long now) {
                QueueData d = (QueueData)TraceWidget.this.queue.poll();
                if (d != null) {
                    d.chart.addEvent(d.categorie, d.start, d.v);
                }
            }
        }.start();
    }

    public XContainer getxContainer() {
        return this.xContainer;
    }

    public void setxContainer(XContainer xContainer) {
        this.xContainer = xContainer;
    }

    private void solveAllPromise(String run, String name) {
        Stack<Promise> prom = this.promissList.get(name);
        if (prom != null) {
            while (!prom.empty()) {
                prom.pop().trySolvePromise();
            }
        }
    }

    public void addPromise(Promise promise) {
        if (this.promissList.get(promise.task) == null) {
            Stack<Promise> stak = new Stack<Promise>();
            stak.add(promise);
            this.promissList.put(promise.task, stak);
        } else {
            this.promissList.get(promise.task).push(promise);
        }
    }

    private class ArrowPromise
    extends Promise {
        XUtil.ResultObj list;
        int offsetX;
        long time;
        DurationModelElement element;
        XUtil.XEntry curer;
        XEventChain ec;
        String task1;
        String task2;
        MultysamplingViewElement box;

        public ArrowPromise(Core c, String task1, XUtil.ResultObj list, int offsetX, long time, DurationModelElement element, XUtil.XEntry curer, XEventChain ec, MultysamplingViewElement box) {
            super(c, curer.getEl().getTasks().getName(), 3);
            this.task1 = task1;
            this.list = list;
            this.offsetX = offsetX;
            this.time = time;
            this.element = element;
            this.curer = curer;
            this.ec = ec;
            this.task2 = curer.getEl().getTasks().getName();
            this.box = box;
        }

        public Promise getMe() {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void trySolvePromise() {
            XEventChain chain = TraceWidget.this.xContainer.getChainByCore(this.core.name);
            int tmp = chain.getIndexxOf(this.curer.getEl());
            LinkedList<XEventElement> linkedList = chain.getFullList(this.task2);
            if (linkedList.size() > tmp + 1) {
                if (linkedList.get(tmp + 1).getStatus() == 0) {
                    TraceWidget.this.addDependecyArrow(this.core, this.task1, new XUtil.XEntry(linkedList.get(tmp + 1), 0), this.time, this.ec, this.box, true);
                    return;
                } else {
                    if (!this.curer.havePromiseAlternative()) return;
                    TraceWidget.this.addDependecyArrow(this.core, this.task1, this.curer.getPromiseAlternative(), this.time, this.ec, this.box, false);
                }
                return;
            } else {
                linkedList.size();
            }
        }
    }

    public static class ArrowTooltip {
        String task1;
        String task2;
        String label;
        long start;
        long time;

        public ArrowTooltip(String task1, String task2, long start, long time, String label) {
            this.task1 = task1;
            this.task2 = task2;
            this.label = label;
            this.time = time;
            this.start = start;
        }

        public String getTask1() {
            return this.task1;
        }

        public String getTask2() {
            return this.task2;
        }

        public String getLabel() {
            return this.label;
        }

        public long getStart() {
            return this.start;
        }

        public long getTime() {
            return this.time;
        }
    }

    static class Core {
        String name;
        FXGanttWidget chart;
        VBox nav;
        Set<String> tasks;

        Core() {
        }
    }

    abstract class Promise {
        public int type;
        public String task;
        public Core core;

        Promise(Core c, String task, int t) {
            this.type = t;
            this.task = task;
            this.core = c;
        }

        public abstract void trySolvePromise();
    }

    static class QueueData {
        final String categorie;
        final long start;
        final AbstractGanttViewElement v;
        final FXGanttWidget chart;

        public QueueData(FXGanttWidget chart, String categorie, long start, AbstractGanttViewElement v) {
            this.chart = chart;
            this.categorie = categorie;
            this.start = start;
            this.v = v;
        }
    }
}

