/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.btf;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfException;
import org.eclipse.app4mc.multicore.execution.logic.btf.fsm.BtfTaskEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.fsm.BtfTaskFSM;
import org.eclipse.app4mc.multicore.execution.logic.btf.fsm.BtfTaskState;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEntityType;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfTrace;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMCore;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTask;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskHistState;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskState;

public class BtfComputer {
    protected static final Map<BtfTaskState, EMTaskState> btfToOSEKState = new EnumMap<BtfTaskState, EMTaskState>(BtfTaskState.class);
    private final BtfTrace trace;
    private final ExecutionModel executionModel;
    private Map<String, BtfTaskFSM> taskFSMs = new HashMap<String, BtfTaskFSM>();
    private String errorMsg = "";
    private Map<BtfEntityType, Function<BtfEvent, Boolean>> translationMap = new EnumMap<BtfEntityType, Function<BtfEvent, Boolean>>(BtfEntityType.class);
    private Map<String, EMTaskHistState> histories = new HashMap<String, EMTaskHistState>();

    static {
        btfToOSEKState.put(BtfTaskState.ACTIVE, EMTaskState.READY);
        btfToOSEKState.put(BtfTaskState.READY, EMTaskState.READY);
        btfToOSEKState.put(BtfTaskState.PARKING, EMTaskState.READY);
        btfToOSEKState.put(BtfTaskState.RUNNING, EMTaskState.RUNNING);
        btfToOSEKState.put(BtfTaskState.POLLING, EMTaskState.RUNNING);
        btfToOSEKState.put(BtfTaskState.WAITING, EMTaskState.WAITING);
        btfToOSEKState.put(BtfTaskState.NOT_INITIALIZED, EMTaskState.SUSPENDED);
        btfToOSEKState.put(BtfTaskState.TERMINATED, EMTaskState.SUSPENDED);
    }

    public BtfComputer(BtfTrace trace, ExecutionModel m) {
        this.trace = trace;
        this.executionModel = m;
        this.setupMap();
    }

    private void setupMap() {
        this.translationMap.put(BtfEntityType.TASK, this::computeTaskEvent);
        this.translationMap.put(BtfEntityType.RUNNABLE, this::computeRunnableEvent);
    }

    public void compute() throws BtfException {
        for (Map.Entry<String, BtfEntityType> centr : this.trace.getEntityTypeTable().entrySet()) {
            if (centr.getValue() != BtfEntityType.CORE) continue;
            EMCore c = new EMCore(centr.getKey());
            this.executionModel.addCore(c);
        }
        for (BtfEvent e : this.trace.getEvents()) {
            Function<BtfEvent, Boolean> comp = this.translationMap.get((Object)e.getTargetType());
            if (comp == null || Boolean.TRUE.equals(comp.apply(e))) continue;
            throw new BtfException(this.errorMsg);
        }
    }

    private Boolean computeTaskEvent(BtfEvent e) {
        BtfEntityType t;
        EMTaskHistState old;
        EMTask task = (EMTask)this.executionModel.getTasks().get(e.getTarget());
        if (task == null) {
            task = new EMTask(e.getTarget());
            this.executionModel.addTask(task);
            this.taskFSMs.put(task.getName(), new BtfTaskFSM(BtfTaskState.NOT_INITIALIZED));
            EMTaskHistState currentHist = EMTaskHistState.EMTaskHistStateFactory.create((EMTaskState)btfToOSEKState.get((Object)BtfTaskState.NOT_INITIALIZED));
            currentHist.setNote("StartState");
            currentHist.setEventSource("Init");
            currentHist.setEnd(e.getTime());
            this.executionModel.addTaskHistEntry(task.getName(), currentHist);
        }
        if ((old = this.histories.get(task.getName())) != null) {
            old.setEnd(e.getTime());
            this.executionModel.addTaskHistEntry(task.getName(), old);
        }
        if ((t = this.trace.getEntityTypeTable().get(e.getSource())) == null) {
            this.errorMsg = "Type for source " + e.getSource() + " not in header!";
            return false;
        }
        EMCore c = (EMCore)this.executionModel.getCores().get(e.getSource());
        BtfTaskFSM tfsm = this.taskFSMs.get(task.getName());
        BtfTaskEvent te = BtfTaskEvent.valueOf(e.getEvent().toUpperCase());
        if (te == null) {
            this.errorMsg = "Unknown event: " + e.getEvent();
            return false;
        }
        if (!tfsm.dispatchEvent(te)) {
            this.errorMsg = "Detected dataloss for tas" + task.getName();
            return false;
        }
        EMTaskHistState newStateHist = EMTaskHistState.EMTaskHistStateFactory.create((EMTaskState)btfToOSEKState.get((Object)tfsm.getState()), (EMCore)c);
        newStateHist.setEventSource(e.getSource());
        if (newStateHist.getNote() == null) {
            newStateHist.setNote(e.getNote());
        }
        newStateHist.setStart(e.getTime());
        this.histories.put(task.getName(), newStateHist);
        return true;
    }

    private Boolean computeRunnableEvent(BtfEvent e) {
        return true;
    }

    public ExecutionModel getExecutionModel() {
        return this.executionModel;
    }
}

