/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.btf.test;

import java.io.File;
import java.util.List;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfException;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfTraceParser;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEntityType;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfTrace;
import org.junit.Assert;
import org.junit.Test;

public class BtfStatePraserTest {
    private static final String TESTFILE = "C:/Users/Tobi/Dropbox/AMALTHEA/APP4MC_Simulator/workspace_amalthea/org.eclipse.app4mc.amalthea.traceeditor/res/example1_task_only_short.btf";
    private BtfTraceParser parser;

    @Test
    public void test() throws BtfException {
        System.out.println("Start test");
        this.parser = new BtfTraceParser(new File(TESTFILE));
        this.parser.parseTrace();
        BtfTrace t = this.parser.getTrace();
        List<BtfEvent> events = t.getEvents();
        Assert.assertEquals((long)15L, (long)events.size());
        for (BtfEvent ev : events) {
            Assert.assertEquals((Object)((Object)ev.getTargetType()), (Object)((Object)BtfEntityType.TASK));
            Assert.assertTrue((ev.getSource().contains("Core") || ev.getSource().contains("Task") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ev.getTarget().contains("Task"));
        }
        Assert.assertEquals((long)4L, (long)t.getEntityTypeTable().size());
        BtfEntityType type = t.getEntityTypeTable().get("Core_1");
        Assert.assertNotEquals(null, (Object)((Object)type));
        Assert.assertEquals((Object)((Object)BtfEntityType.CORE), (Object)((Object)type));
        type = t.getEntityTypeTable().get("Core_2");
        Assert.assertNotEquals(null, (Object)((Object)type));
        Assert.assertEquals((Object)((Object)BtfEntityType.CORE), (Object)((Object)type));
        type = t.getEntityTypeTable().get("Task_A");
        Assert.assertNotEquals(null, (Object)((Object)type));
        Assert.assertEquals((Object)((Object)BtfEntityType.TASK), (Object)((Object)type));
        type = t.getEntityTypeTable().get("Task_B");
        Assert.assertNotEquals(null, (Object)((Object)type));
        Assert.assertEquals((Object)((Object)BtfEntityType.TASK), (Object)((Object)type));
    }
}

