/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.traceeditor;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfComputer;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfException;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfTraceParser;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfTrace;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.ui.traceeditor.FXEditorPart;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.EMTraceWidget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class TraceEditor
extends FXEditorPart {
    private IEditorInput input;
    EMTraceWidget tw;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.input = input;
        this.setInput(input);
        this.setPartName("computing...");
    }

    BtfTrace manageParsing() {
        if (!(this.input instanceof IFileEditorInput)) {
            this.handleWarning("BTF-Parsing", "No file input for TraceEditor!");
            return null;
        }
        System.out.println("Is FileEditorInput");
        IFileEditorInput fei = (IFileEditorInput)this.input;
        System.out.println("File: " + fei.getFile().getName());
        IFile file = fei.getFile();
        IPath location = file.getLocation();
        if (location == null) {
            this.handleWarning("BTF-Parsing", "File location not found!");
            return null;
        }
        BtfTraceParser parser = new BtfTraceParser(location.toFile());
        try {
            parser.parseTrace();
        }
        catch (BtfException e) {
            this.handleWarning("BTF-Parsing", "Error while parsing! \n" + e.getMessage());
            e.printStackTrace();
        }
        this.setPartName(file.getName());
        return parser.getTrace();
    }

    @Override
    protected Scene createFxScene() {
        this.tw = new EMTraceWidget();
        new Thread(new Runnable(){

            @Override
            public void run() {
                BtfTrace trace = TraceEditor.this.manageParsing();
                ExecutionModel m = new ExecutionModel();
                BtfComputer com = new BtfComputer(trace, m);
                try {
                    com.compute();
                    TraceEditor.this.tw.addExecutionModel(m);
                }
                catch (BtfException e) {
                    TraceEditor.this.handleWarning("Malformed BTF-Trace", e.getMessage());
                }
            }
        }).start();
        ScrollPane pane = new ScrollPane();
        pane.setContent((Node)this.tw);
        pane.setFitToWidth(true);
        return new Scene((Parent)pane);
    }

    void handleWarning(final String title, final String msg) {
        System.err.println(String.valueOf(title) + ": " + msg);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)TraceEditor.this.getSite().getShell(), (String)title, (String)msg);
            }
        });
    }

    @Override
    protected void setFxFocus() {
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

