/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import org.eclipse.equinox.internal.useradmin.LogTracker;
import org.eclipse.equinox.internal.useradmin.Role;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class UserAdminEventProducer
extends ServiceTracker
implements EventDispatcher {
    protected ServiceReference userAdmin;
    protected static final String userAdminListenerClass = "org.osgi.service.useradmin.UserAdminListener";
    protected LogTracker log;
    protected EventListeners listeners;
    protected EventManager eventManager;

    protected UserAdminEventProducer(ServiceReference userAdmin, BundleContext context, LogTracker log) {
        super(context, userAdminListenerClass, null);
        this.userAdmin = userAdmin;
        this.log = log;
        ThreadGroup eventGroup = new ThreadGroup("Equinox User Admin");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("UserAdmin Event Dispatcher", eventGroup);
        this.listeners = new EventListeners();
        this.open();
    }

    public void close() {
        super.close();
        this.listeners.removeAllListeners();
        this.eventManager.close();
        this.userAdmin = null;
    }

    protected void generateEvent(int type, Role role) {
        if (this.userAdmin != null) {
            UserAdminEvent event = new UserAdminEvent(this.userAdmin, type, (org.osgi.service.useradmin.Role)role);
            ListenerQueue queue = new ListenerQueue(this.eventManager);
            queue.queueListeners(this.listeners, (EventDispatcher)this);
            queue.dispatchEventAsynchronous(0, (Object)event);
        }
    }

    public Object addingService(ServiceReference reference) {
        Object service = super.addingService(reference);
        this.listeners.addListener(service, service);
        return service;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.listeners.removeListener(service);
        super.removedService(reference, service);
    }

    public void dispatchEvent(Object listener, Object listenerObject, int eventAction, Object eventObject) {
        if (this.userAdmin == null) {
            return;
        }
        UserAdminListener ual = (UserAdminListener)listener;
        try {
            ual.roleChanged((UserAdminEvent)eventObject);
        }
        catch (Throwable t) {
            this.log.log(this.userAdmin, 2, UserAdminMsg.Event_Delivery_Exception, t);
        }
    }
}

