/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ga.constraints;

import java.util.stream.Stream;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractGABasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ProblemGraph;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.TimeStep;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.jenetics.Chromosome;
import org.jenetics.Genotype;
import org.jenetics.IntegerChromosome;
import org.jenetics.IntegerGene;
import org.jenetics.Optimize;
import org.jenetics.engine.Engine;
import org.jenetics.engine.EvolutionResult;
import org.jenetics.engine.EvolutionStatistics;
import org.jenetics.engine.EvolutionStream;
import org.jenetics.util.Factory;

public class GABasedConstraints
extends AbstractGABasedMappingAlgorithm {
    private static ProblemGraph problemGraph;
    private static long[][] utilMatrix;

    @Override
    public void calculateMapping() {
        this.con.appendln("Performing GA based Hard/Soft Constraint violation optimization");
        this.con.appendln("Preparing Models...");
        if (!this.initModels()) {
            this.con.appendln("Error during Model initialization, exiting.");
            return;
        }
        TimeStep timeStep = new TimeStep();
        this.con.appendln("Generating ProblemGraph...");
        problemGraph = new ProblemGraph(this.getMergedModel());
        if (!problemGraph.initialize()) {
            this.con.appendln("Error during ProblemGraph initialization, exiting.");
            return;
        }
        this.con.appendln("Success after " + timeStep.getTimeStep() / 1000000L + "ms.");
        this.con.appendln("Creating Mapping...");
        if (!this.performMappingAlgorithm()) {
            this.con.appendln("Error during performMappingAlgorithm, exiting.");
            return;
        }
        this.con.appendln("Success after " + timeStep.getTimeStep() / 1000000L + "ms.");
        this.con.appendln("Leaving mapping algorithm.");
    }

    private static boolean checkValidCores(OMTask task, OMCore core) {
        return problemGraph.getValidAlocationTargets(task).contains(core);
    }

    private void printWarnings(Genotype<IntegerGene> mappingResult) {
        int taskIndex = 0;
        boolean violationDetected = false;
        Chromosome chromosome = mappingResult.getChromosome(0);
        if (GABasedConstraints.evaluate(mappingResult) == 0.0) {
            return;
        }
        String output = "+--------------------------------------------------------+\n";
        output = String.valueOf(output) + "|             WARNING! Constraints Violated              |\n";
        output = String.valueOf(output) + "+------------------+------------------+------------------+\n";
        output = String.valueOf(output) + "| Type             | Task             | Core             |\n";
        output = String.valueOf(output) + "+------------------+------------------+------------------+\n";
        for (IntegerGene gene : chromosome) {
            int coreIndex = (Integer)gene.getAllele();
            OMCore core = problemGraph.getCoreList().get(coreIndex);
            OMTask task = problemGraph.getTaskList().get(taskIndex++);
            if (GABasedConstraints.checkValidCores(task, core)) continue;
            violationDetected = true;
            output = String.valueOf(output) + String.format("| %-16s | %-16s | %-16s |\n", "Tag", task.getTaskRef().getName(), core.getCoreRef().getName());
            output = String.valueOf(output) + "+------------------+------------------+------------------+\n";
        }
        if (violationDetected) {
            this.con.appendln("\n" + output);
        }
    }

    private boolean performMappingAlgorithm() {
        int noCores = problemGraph.getCoreList().size();
        int noTasks = problemGraph.getTaskList().size();
        utilMatrix = new long[noCores][noTasks];
        if (noCores == 1) {
            return this.mapToFirstCore();
        }
        int coreIndex = 0;
        while (coreIndex < noCores) {
            int taskIndex = 0;
            while (taskIndex < noTasks) {
                OMAllocation allocation = new OMAllocation(problemGraph.getTaskList().get(taskIndex), problemGraph.getCoreList().get(coreIndex));
                GABasedConstraints.utilMatrix[coreIndex][taskIndex] = allocation.calculateProcessingTime();
                ++taskIndex;
            }
            ++coreIndex;
        }
        Genotype gtf = Genotype.of((Chromosome)IntegerChromosome.of((int)0, (int)(noCores - 1), (int)noTasks), (Chromosome[])new Chromosome[0]);
        Engine engine = Engine.builder(GABasedConstraints::evaluate, (Factory)gtf).optimize(Optimize.MINIMUM).populationSize(noTasks).build();
        Throwable throwable = null;
        Object var6_9 = null;
        try (EvolutionStream stream = engine.stream();){
            EvolutionStatistics statistics = EvolutionStatistics.ofNumber();
            Stream stream2 = stream.limit(1000L).peek(statistics);
            Genotype result = (Genotype)stream2.collect(EvolutionResult.toBestGenotype());
            this.con.appendln(statistics.toString());
            this.con.appendln(String.valueOf(result.toString()) + " -> " + GABasedConstraints.evaluate((Genotype<IntegerGene>)result));
            this.printWarnings((Genotype<IntegerGene>)result);
            OMMapping mapping = this.generateOMMapping((Genotype<IntegerGene>)result);
            this.updateModel(mapping);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    @Override
    protected OMMapping generateOMMapping(Genotype<IntegerGene> mappingResult) {
        OMMapping mapping = new OMMapping();
        int taskIndex = 0;
        Chromosome chromosome = mappingResult.getChromosome(0);
        if (mappingResult.length() != 1) {
            this.con.appendln("Invalid number of Genes");
            return null;
        }
        System.out.println("+--------------------------------------------------------+");
        System.out.println("|                   Mapping Summary                      |");
        System.out.println("+----------------------------+---------------------------+");
        System.out.println("|            Task            |             Core          |");
        System.out.println("+----------------------------+---------------------------+");
        for (IntegerGene gene : chromosome) {
            int coreIndex = (Integer)gene.getAllele();
            OMCore core = problemGraph.getCoreList().get(coreIndex);
            OMTask task = problemGraph.getTaskList().get(taskIndex++);
            System.out.printf("| %-26s | %-25s |\n", task.getTaskRef().getName(), core.getCoreRef().getName());
            System.out.println("+----------------------------+---------------------------+\n");
            OMAllocation alloc = new OMAllocation(task, core);
            mapping.addAllocation(alloc);
        }
        System.out.println("+----------------------------+---------------------------+\n");
        return mapping;
    }

    private static int countHardConstraintsViolations(OMTask task, OMCore core) {
        int violationCount = 0;
        if (!GABasedConstraints.checkValidCores(task, core)) {
            ++violationCount;
        }
        return violationCount;
    }

    private static int countSoftConstraintsViolations(OMTask task, OMCore core) {
        return 0;
    }

    private static Double calculateLoadImbalance(Chromosome<IntegerGene> chromosome) {
        double loadImbalance = 0.0;
        double[] coreExecutionTime = new double[problemGraph.getCoreList().size()];
        double meanExecutionTime = 0.0;
        double maxExecutionTime = 0.0;
        int taskIndex = 0;
        for (IntegerGene gene : chromosome) {
            int coreIndex;
            int n = coreIndex = ((Integer)gene.getAllele()).intValue();
            coreExecutionTime[n] = coreExecutionTime[n] + (double)utilMatrix[coreIndex][taskIndex++];
        }
        double[] dArray = coreExecutionTime;
        int n = coreExecutionTime.length;
        int n2 = 0;
        while (n2 < n) {
            double coreExcTime = dArray[n2];
            maxExecutionTime = coreExcTime > maxExecutionTime ? coreExcTime : maxExecutionTime;
            ++n2;
        }
        int coreIndex = 0;
        while (coreIndex < coreExecutionTime.length) {
            coreExecutionTime[coreIndex] = coreExecutionTime[coreIndex] / maxExecutionTime;
            ++coreIndex;
        }
        dArray = coreExecutionTime;
        n = coreExecutionTime.length;
        n2 = 0;
        while (n2 < n) {
            double coreExcTime = dArray[n2];
            meanExecutionTime += coreExcTime;
            ++n2;
        }
        meanExecutionTime /= (double)coreExecutionTime.length;
        dArray = coreExecutionTime;
        n = coreExecutionTime.length;
        n2 = 0;
        while (n2 < n) {
            double coreExcTime = dArray[n2];
            loadImbalance += Math.pow(coreExcTime - meanExecutionTime, 2.0);
            ++n2;
        }
        loadImbalance /= (double)(coreExecutionTime.length - 1);
        loadImbalance = Math.sqrt(loadImbalance);
        return loadImbalance;
    }

    public static Double evaluate(Genotype<IntegerGene> gt) {
        Double penaltySum = 0.0;
        int taskIndex = 0;
        Chromosome chromosome = gt.getChromosome(0);
        penaltySum = penaltySum + 100.0 * GABasedConstraints.calculateLoadImbalance((Chromosome<IntegerGene>)chromosome);
        for (IntegerGene gene : chromosome) {
            int coreIndex = (Integer)gene.getAllele();
            OMCore core = problemGraph.getCoreList().get(coreIndex);
            OMTask task = problemGraph.getTaskList().get(taskIndex++);
            penaltySum = penaltySum + (double)(100 * GABasedConstraints.countHardConstraintsViolations(task, core));
            penaltySum = penaltySum + (double)(1 * GABasedConstraints.countSoftConstraintsViolations(task, core));
        }
        return penaltySum;
    }
}

