/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.CoreClassifier;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ReferenceObject;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.multicore.openmapping.model.OMAnnotationElement;
import org.eclipse.app4mc.multicore.openmapping.model.OMCoreClassifier;
import org.eclipse.app4mc.multicore.openmapping.model.OMRunnable;
import org.eclipse.app4mc.multicore.openmapping.model.OMTag;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.emf.common.util.EList;

public class OMTask {
    private static final String sTokenInclude = "[ConstraintInclude]";
    private static final String sTokenExclude = "[ConstraintExclude]";
    private final Task taskRef;
    private OMTask predecessor = null;
    private long iInstructionCount = -1L;
    private long iRunnableCount = -1L;
    private long iPeriod = -1L;
    private static long iMaxPeriod = -1L;
    private ArrayList<OMAnnotationElement> validTags = new ArrayList();
    private ArrayList<OMAnnotationElement> invalidTags = new ArrayList();

    public OMTask(Task taskRef) {
        this.taskRef = taskRef;
        this.addAnnotationElements();
    }

    public OMTask(Task taskRef, OMTask predecessor) {
        this(taskRef);
        this.predecessor = predecessor;
    }

    private void addAnnotationElements() {
        if (this.getTaskRef().getCustomProperties().size() > 0) {
            Map itPropertyConstraints = this.getTaskRef().getCustomProperties().map();
            itPropertyConstraints.forEach((k, v) -> this.parsePropertyConstraint((String)k, (Value)v));
        }
    }

    private void parsePropertyConstraint(String k, Value v) {
        UniversalHandler.getInstance().logCon("T: " + this.taskRef.getName() + " - Parsing (K: " + k + " V: " + v + ")");
        if (v instanceof ReferenceObject) {
            OMAnnotationElement ot;
            ReferenceObject ref = (ReferenceObject)v;
            if (ref.getValue() instanceof Tag) {
                ot = new OMTag((Tag)ref.getValue());
                if (k.contains(sTokenInclude)) {
                    this.validTags.add(ot);
                } else if (k.contains(sTokenExclude)) {
                    this.invalidTags.add(ot);
                }
            }
            if (ref.getValue() instanceof CoreClassifier) {
                ot = new OMCoreClassifier((CoreClassifier)ref.getValue());
                if (k.contains(sTokenInclude)) {
                    this.validTags.add(ot);
                } else if (k.contains(sTokenExclude)) {
                    this.invalidTags.add(ot);
                }
            }
        }
    }

    private void fetchRunnableAndInstructionCount() {
        ActivityGraph callGraph = this.taskRef.getActivityGraph();
        if (callGraph == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, Task '" + this.taskRef.getName() + "' has an invalid or missing containment to its CallGraph.", null);
            return;
        }
        if (callGraph.getItems().isEmpty()) {
            UniversalHandler.getInstance().log("Invalid Software Model, The CallGraph of Task '" + this.taskRef.getName() + "' is empty", null);
            return;
        }
        ++this.iRunnableCount;
        this.iInstructionCount = this.processCallGraph(callGraph);
    }

    private long processCallGraph(ActivityGraph callGraph) {
        long tmpInstr = 0L;
        for (ActivityGraphItem graphEntry : callGraph.getItems()) {
            if (graphEntry instanceof Group) {
                tmpInstr += this.processGroup((Group)graphEntry);
                continue;
            }
            if (graphEntry instanceof ModeSwitch) {
                UniversalHandler.getInstance().log("GraphEntry specialisation LabelSwitch is not supported. Skipping...", null, 2);
                continue;
            }
            if (graphEntry instanceof ProbabilitySwitch) {
                UniversalHandler.getInstance().log("GraphEntry specialisation ProbabilitySwitch is not supported. Skipping...", null, 2);
                continue;
            }
            UniversalHandler.getInstance().log("Unkown GraphEntry specialisation. Skipping...", null);
        }
        return tmpInstr;
    }

    private long processGroup(Group group) {
        long tmpInstr = 0L;
        if (group.getItems().isEmpty()) {
            UniversalHandler.getInstance().log("Invalid Software Model, Group must not be empty. Skipping...", null);
            return tmpInstr;
        }
        for (ActivityGraphItem callSeqEntry : group.getItems()) {
            if (callSeqEntry instanceof RunnableCall) {
                tmpInstr += this.processRunnableCall((RunnableCall)callSeqEntry);
                continue;
            }
            UniversalHandler.getInstance().logWarn("Unkown CallSequenceItem specialisation. Skipping...");
        }
        return tmpInstr;
    }

    private long processRunnableCall(RunnableCall RunnableCall2) {
        Runnable runnable = RunnableCall2.getRunnable();
        if (runnable == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, reference to Runnable must not be empty. Skipping...", null);
            return 0L;
        }
        ++this.iRunnableCount;
        OMRunnable r = new OMRunnable(runnable);
        return r.getInstructionCount();
    }

    public String toString() {
        return this.taskRef.getUniqueName();
    }

    public long getPeriod() {
        EList lSt = this.getTaskRef().getStimuli();
        if (lSt == null || lSt.isEmpty()) {
            UniversalHandler.getInstance().log("Stimuli not set.\nSkipping Task " + this.taskRef.getName(), null);
            return this.iPeriod;
        }
        if (this.iPeriod < 0L) {
            for (Stimulus s : lSt) {
                if (s instanceof PeriodicStimulus) {
                    PeriodicStimulus ps = (PeriodicStimulus)s;
                    Time x = ps.getRecurrence();
                    if (x == null) {
                        this.iPeriod = 0L;
                        return this.iPeriod;
                    }
                    long val = x.getValue().longValue();
                    if (val == 0L || x.getUnit() == null) {
                        this.iPeriod = 0L;
                        return this.iPeriod;
                    }
                    switch (x.getUnit()) {
                        case PS: {
                            val *= 1L;
                            break;
                        }
                        case NS: {
                            val *= 1000L;
                            break;
                        }
                        case US: {
                            val *= 1000000L;
                            break;
                        }
                        case MS: {
                            val *= 1000000000L;
                            break;
                        }
                        case S: {
                            val *= 1000000000000L;
                            break;
                        }
                        default: {
                            this.iPeriod = 0L;
                            return this.iPeriod;
                        }
                    }
                    this.iPeriod = val;
                    if (this.iPeriod > iMaxPeriod) {
                        iMaxPeriod = this.iPeriod;
                    }
                    return this.iPeriod;
                }
                if (!(s instanceof RelativePeriodicStimulus)) continue;
                RelativePeriodicStimulus spst = (RelativePeriodicStimulus)s;
                ITimeDeviation dev = spst.getNextOccurrence();
                Time x = dev.getLowerBound();
                if (x == null) {
                    this.iPeriod = 0L;
                    return this.iPeriod;
                }
                long val = x.getValue().longValue();
                if (val == 0L || x.getUnit() == null) {
                    this.iPeriod = 0L;
                    return this.iPeriod;
                }
                switch (x.getUnit()) {
                    case PS: {
                        val *= 1L;
                        break;
                    }
                    case NS: {
                        val *= 1000L;
                        break;
                    }
                    case US: {
                        val *= 1000000L;
                        break;
                    }
                    case MS: {
                        val *= 1000000000L;
                        break;
                    }
                    case S: {
                        val *= 1000000000000L;
                        break;
                    }
                    default: {
                        this.iPeriod = 0L;
                        return this.iPeriod;
                    }
                }
                this.iPeriod = val;
                if (this.iPeriod > iMaxPeriod) {
                    iMaxPeriod = this.iPeriod;
                }
                return this.iPeriod;
            }
            this.iPeriod = 0L;
        }
        return this.iPeriod;
    }

    public double getRecursionFactor() {
        if (this.iPeriod < 0L) {
            this.getPeriod();
        }
        return (double)iMaxPeriod / (double)this.iPeriod;
    }

    public Task getTaskRef() {
        return this.taskRef;
    }

    public OMTask getPredecessor() {
        return this.predecessor;
    }

    public long getInstructionCount() {
        if (0L > this.iInstructionCount) {
            this.fetchRunnableAndInstructionCount();
        }
        return this.iInstructionCount;
    }

    public long getRunnableCount() {
        if (0L > this.iRunnableCount) {
            this.fetchRunnableAndInstructionCount();
        }
        return this.iRunnableCount;
    }

    public ArrayList<OMAnnotationElement> getValidAnnotationElements() {
        return this.validTags;
    }

    public ArrayList<OMAnnotationElement> getInvalidAnnotationElements() {
        return this.invalidTags;
    }

    public static void init() {
        iMaxPeriod = -1L;
    }

    public static long getMaxPeriod() {
        return iMaxPeriod;
    }
}

