/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.emf.common.util.EList;

public class ModelSpecProcessPrototypeRunnableCall
extends ModelSpec {
    public static ModelSpecProcessPrototypeRunnableCall build() {
        ModelSpecProcessPrototypeRunnableCall spec = new ModelSpecProcessPrototypeRunnableCall();
        spec.name = spec.specType = "Process Prototype has Runnable Calls";
        return spec;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (ProcessPrototype procProto : model.getSwModel().getProcessPrototypes()) {
            EList runCall = procProto.getRunnableCalls();
            if (runCall.isEmpty()) {
                this.log("Process Prototype " + procProto.getName() + " has no runnable calls.");
                cond &= false;
                continue;
            }
            for (RunnableCall call : runCall) {
                if (call.getRunnable() != null) continue;
                this.log("Process Prototype " + procProto.getName() + " has a runnable call with pointing to NULL.");
                cond &= false;
            }
        }
        return cond;
    }

    public ModelSpecProcessPrototypeRunnableCall setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

