/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecTaskRunnableCall
extends ModelSpec {
    public static ModelSpecTaskRunnableCall build() {
        ModelSpecTaskRunnableCall spec = new ModelSpecTaskRunnableCall();
        spec.name = spec.specType = "Task has Runnable Calls";
        return spec;
    }

    private Group findCallSequence(ActivityGraph cg) {
        for (ActivityGraphItem ge : cg.getItems()) {
            if (!(ge instanceof Group)) continue;
            return (Group)ge;
        }
        return null;
    }

    private boolean checkRunnableCalls(Task task, Group cs) {
        boolean cond = true;
        int amountTask = 0;
        for (ActivityGraphItem csi : cs.getItems()) {
            if (!(csi instanceof RunnableCall)) continue;
            RunnableCall trc = (RunnableCall)csi;
            if (trc.getRunnable() == null) {
                this.log("Task " + task.getName() + " has a call without a valid Runnable reference.");
                cond &= false;
                continue;
            }
            ++amountTask;
        }
        if (amountTask == 0) {
            this.log("Task " + task.getName() + " has a Call Sequence without any Calls set.");
            cond &= false;
        }
        return cond;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Task task : model.getSwModel().getTasks()) {
            ActivityGraph cg = task.getActivityGraph();
            if (cg == null) {
                this.log("Task " + task.getName() + " doesn't have a CallGraph set.");
                cond &= false;
                continue;
            }
            Group cs = this.findCallSequence(cg);
            if (cs == null) {
                this.log("Task " + task.getName() + " doesn't have a Call Sequence set.");
                cond &= false;
                continue;
            }
            if (cs.getItems().isEmpty()) {
                this.log("Task " + task.getName() + " has a Call Sequence without any Calls set.");
                cond &= false;
                continue;
            }
            cond &= this.checkRunnableCalls(task, cs);
        }
        return cond;
    }

    public ModelSpecTaskRunnableCall setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

