/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.emf.common.util.EList;

public class ModelSpecTaskStimuli
extends ModelSpec {
    public static ModelSpecTaskStimuli build() {
        ModelSpecTaskStimuli spec = new ModelSpecTaskStimuli();
        spec.name = spec.specType = "Tasks' have Stimuli";
        return spec;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Task task : model.getSwModel().getTasks()) {
            EList stimList = task.getStimuli();
            if (stimList.isEmpty()) {
                this.log("Task " + task.getName() + " doesn't have a Stimulus set.");
                cond &= false;
                continue;
            }
            for (Stimulus stim : stimList) {
                if (stim instanceof PeriodicStimulus) continue;
                this.log("Task " + task.getName() + " has a non-Periodic stimulus (not yet supported).");
                cond &= false;
            }
        }
        return cond;
    }

    public ModelSpecTaskStimuli setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

