/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class MappingConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.0 to 0.8.1 : Executing Mapping converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateMappingModel_coreAllocation(rootElement);
        this.updateMappingModel_schedulerAllocation(rootElement);
    }

    private void updateMappingModel_schedulerAllocation(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./mappingModel/taskAllocation");
        List taskAllocationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        boolean priorityAddedAsSchedulingParameter = false;
        for (Element taskAllocationElement : taskAllocationElements) {
            Attribute priorityAttribute = taskAllocationElement.getAttribute("priority");
            if (priorityAttribute == null) continue;
            String value = priorityAttribute.getValue();
            taskAllocationElement.removeAttribute(priorityAttribute);
            if (value.equals("0")) continue;
            priorityAddedAsSchedulingParameter = true;
            Element schedulingParametersElement = new Element("schedulingParameters");
            schedulingParametersElement.setAttribute("priority", value);
            taskAllocationElement.addContent((Content)schedulingParametersElement);
        }
        if (priorityAddedAsSchedulingParameter) {
            LOGGER.info("Priority is removed from TaskAllocation elements and added as a attribute in corresponding SchedulingParameters element");
        }
    }

    private void updateMappingModel_coreAllocation(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./mappingModel/coreAllocation");
        List coreAllocationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element coreAllocationElement : coreAllocationElements) {
            coreAllocationElement.setName("schedulerAllocation");
            Attribute coreAttribute = coreAllocationElement.getAttribute("core");
            Element coreElement = coreAllocationElement.getChild("core");
            if (coreAttribute != null) {
                coreAttribute.setName("responsibility");
                continue;
            }
            if (coreElement == null) continue;
            coreElement.setName("responsibility");
        }
    }
}

