/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StimuliConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.0 to 0.8.1 : Executing Stimuli converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateAllModeValueListEntryElements(rootElement);
        this.updateAllStimulusElements(rootElement);
        this.updateCustomPropertiesForStimulus(rootElement);
    }

    private void updateCustomPropertiesForStimulus(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append(".//customProperties/value[@value]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties/value/value");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties//values[@value]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties//values/value");
        HashMap<String, String> namesMap = new HashMap<String, String>();
        namesMap.put("ArrivalCurve", "ArrivalCurveStimulus");
        namesMap.put("InterProcess", "InterProcessStimulus");
        namesMap.put("Periodic", "PeriodicStimulus");
        namesMap.put("PeriodicEvent", "VariableRateStimulus");
        namesMap.put("Single", "SingleStimulus");
        namesMap.put("Sporadic", "SporadicStimulus");
        namesMap.put("Synthetic", "SyntheticStimulus");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : elements) {
            String newValue;
            String stimulusName;
            int indexOfEquals;
            String value;
            Attribute typeAttribute = element.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            Attribute valueAttribute = element.getAttribute("value");
            Attribute hrefAttribute = element.getAttribute("href");
            if (typeAttribute != null && valueAttribute != null) {
                value = valueAttribute.getValue();
                indexOfEquals = value.indexOf(61);
                if (indexOfEquals == -1 || !namesMap.containsKey(stimulusName = value.substring(indexOfEquals + 1, value.length()))) continue;
                newValue = String.valueOf(value.substring(0, indexOfEquals + 1)) + (String)namesMap.get(stimulusName);
                valueAttribute.setValue(newValue);
                continue;
            }
            if (valueAttribute != null || hrefAttribute == null || typeAttribute == null) continue;
            this.updateStimulusTypeAttribute(element);
            value = hrefAttribute.getValue();
            indexOfEquals = value.indexOf(61);
            if (indexOfEquals == -1 || !namesMap.containsKey(stimulusName = value.substring(indexOfEquals + 1, value.length()))) continue;
            newValue = String.valueOf(value.substring(0, indexOfEquals + 1)) + (String)namesMap.get(stimulusName);
            hrefAttribute.setValue(newValue);
        }
    }

    private void updateAllStimulusElements(Element rootElement) {
        this.updateAllStimulusElementsDefinition(rootElement);
        this.updateAllStimulusElementsReferences(rootElement);
    }

    private void updateAllStimulusElementsReferences(Element rootElement) {
        HashMap<String, String> old_new_StimulusNamesMap = new HashMap<String, String>();
        old_new_StimulusNamesMap.put("ArrivalCurve", "ArrivalCurveStimulus");
        old_new_StimulusNamesMap.put("InterProcess", "InterProcessStimulus");
        old_new_StimulusNamesMap.put("Periodic", "PeriodicStimulus");
        old_new_StimulusNamesMap.put("PeriodicEvent", "VariableRateStimulus");
        old_new_StimulusNamesMap.put("Single", "SingleStimulus");
        old_new_StimulusNamesMap.put("Sporadic", "SporadicStimulus");
        old_new_StimulusNamesMap.put("Synthetic", "SyntheticStimulus");
        StringBuilder stimulusEventBuffer = new StringBuilder();
        stimulusEventBuffer.append("./eventModel/events[@xsi:type=\"am:StimulusEvent\"]");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, stimulusEventBuffer, "entity", false);
        StringBuilder processBuffer = new StringBuilder();
        processBuffer.append("./swModel/tasks");
        processBuffer.append("|");
        processBuffer.append("./swModel/isrs");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, processBuffer, "stimuli", false);
        StringBuilder interProcessActivationBuffer = new StringBuilder();
        interProcessActivationBuffer.append("./swModel/tasks//calls[@xsi:type=\"am:InterProcessActivation\"]");
        interProcessActivationBuffer.append("|");
        interProcessActivationBuffer.append("./swModel/isrs//calls[@xsi:type=\"am:InterProcessActivation\"]");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, interProcessActivationBuffer, "stimulus", true);
    }

    private void updateStimulusReferences(Element rootElement, Map<String, String> old_new_StimulusNamesMap, StringBuilder stimulusEventBuffer, String variableName, boolean isInterProcessActivation) {
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)stimulusEventBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element targetElement : elements) {
            String typeValue;
            Attribute typeAttribute;
            Attribute attribute = targetElement.getAttribute(variableName);
            if (attribute != null) {
                StringBuilder updatedValueBuffer = new StringBuilder();
                StringTokenizer stk = new StringTokenizer(attribute.getValue());
                while (stk.hasMoreTokens()) {
                    String nextToken = stk.nextToken();
                    updatedValueBuffer.append(String.valueOf(this.getUpdatedStimulusReference(nextToken, old_new_StimulusNamesMap, isInterProcessActivation)) + " ");
                }
                String trimmedValue = updatedValueBuffer.toString().trim();
                if (trimmedValue.length() != 0) {
                    attribute.setValue(trimmedValue);
                } else {
                    attribute.detach();
                }
            }
            List children = HelperUtil.getXpathResult((Element)targetElement, (String)("./" + variableName), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
            for (Element element : children) {
                String updatedValue;
                String value;
                String attributeValue;
                if (isInterProcessActivation && (attributeValue = element.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) != null && !attributeValue.equals("InterProcess")) {
                    element.detach();
                    continue;
                }
                this.updateStimulusTypeAttribute(element);
                Attribute hrefAttribute = element.getAttribute("href");
                if (hrefAttribute == null || (value = hrefAttribute.getValue()).equals(updatedValue = this.getUpdatedStimulusReference(value, old_new_StimulusNamesMap, isInterProcessActivation))) continue;
                hrefAttribute.setValue(updatedValue);
            }
            if (!isInterProcessActivation || (typeAttribute = targetElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) == null || !(typeValue = typeAttribute.getValue()).equals("am:InterProcessActivation")) continue;
            typeAttribute.setValue("am:InterProcessTrigger");
        }
    }

    private String getUpdatedStimulusReference(String token, Map<String, String> old_new_StimulusNamesMap, boolean isInterProcessActivation) {
        int indexOfEquals = token.indexOf(61);
        if (indexOfEquals != -1) {
            String stimulusType = token.substring(indexOfEquals + 1, token.length());
            if (isInterProcessActivation && !stimulusType.equals("InterProcess")) {
                return "";
            }
            if (old_new_StimulusNamesMap.containsKey(stimulusType)) {
                return String.valueOf(token.substring(0, indexOfEquals + 1)) + old_new_StimulusNamesMap.get(stimulusType);
            }
        }
        return token;
    }

    private void updateAllStimulusElementsDefinition(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./stimuliModel/stimuli");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element stimulusElement : stimulusElements) {
            this.updateStimulusTypeAttribute(stimulusElement);
        }
    }

    private void updateStimulusTypeAttribute(Element stimulusElement) {
        Attribute typeAttribute = stimulusElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (typeAttribute != null) {
            String stimulusType = typeAttribute.getValue();
            if (stimulusType.equals("am:EventStimulus")) {
                this.updateEventStimulus(stimulusElement);
            } else if (stimulusType.equals("am:ArrivalCurve")) {
                typeAttribute.setValue("am:ArrivalCurveStimulus");
            } else if (stimulusType.equals("am:InterProcess")) {
                typeAttribute.setValue("am:InterProcessStimulus");
            } else if (stimulusType.equals("am:Periodic")) {
                typeAttribute.setValue("am:PeriodicStimulus");
            } else if (stimulusType.equals("am:PeriodicEvent")) {
                typeAttribute.setValue("am:VariableRateStimulus");
            } else if (stimulusType.equals("am:Single")) {
                typeAttribute.setValue("am:SingleStimulus");
            } else if (stimulusType.equals("am:Sporadic")) {
                typeAttribute.setValue("am:SporadicStimulus");
            } else if (stimulusType.equals("am:Synthetic")) {
                typeAttribute.setValue("am:SyntheticStimulus");
            }
        }
    }

    private void updateEventStimulus(Element stimulusElement) {
        List triggerElements;
        Attribute triggerAttribute = stimulusElement.getAttribute("trigger");
        if (triggerAttribute != null) {
            triggerAttribute.setName("triggeringEvents");
        }
        if ((triggerElements = stimulusElement.getChildren("trigger")) != null) {
            for (Element triggerElement : triggerElements) {
                triggerElement.setName("triggeringEvents");
            }
        }
    }

    private void updateAllModeValueListEntryElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./stimuliModel/stimuli/setModeValueList/entries");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/enablingModeValueList/entries");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/disablingModeValueList/entries");
        List modeValueListEntryElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element modeValueListEntry : modeValueListEntryElements) {
            modeValueListEntry.setAttribute("type", "am:ModeValue", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        }
    }
}

