/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.2", "output_model_version=0.8.0"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.2 to 0.8.0 : Executing SW converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_mode_Label(rootElement);
        this.update_DataSize(rootElement);
        this.update_ProbabiltitySwitch(rootElement);
    }

    private void update_ProbabiltitySwitch(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks//*[@xsi:type=\"am:ProbabiltitySwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs//*[@xsi:type=\"am:ProbabilitySwitch\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element probabilitySwitchElement : elements) {
            Attribute attribute = probabilitySwitchElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (attribute == null) continue;
            attribute.setValue("am:ProbabilitySwitch");
        }
    }

    private void update_DataSize(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/typeDefinitions[@xsi:type=\"am:BaseTypeDefinition\"]/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/memoryTypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/runnableItems//transmissionPolicy/chunkSize");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/modeLabels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/channels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/customEntities/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/size");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element dataSizeElement : elements) {
            Attribute attribute = dataSizeElement.getAttribute("unit");
            if (attribute == null) continue;
            String value = attribute.getValue();
            if (value.equals("kibit")) {
                attribute.setValue("Kibit");
                continue;
            }
            if (!value.equals("byte")) continue;
            attribute.setValue("B");
        }
    }

    private void update_mode_Label(Element rootElement) {
        StringBuilder labelXpathBuffer = new StringBuilder();
        labelXpathBuffer.append("./swModel/modeLabels");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)labelXpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element modeLabel : elements) {
            Attribute modeAttribute = modeLabel.getAttribute("mode");
            if (modeAttribute != null) {
                modeLabel.removeAttribute(modeAttribute);
                continue;
            }
            Element modeElement = modeLabel.getChild("mode");
            if (modeElement == null) continue;
            modeLabel.removeChild("mode");
        }
    }
}

