/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb.wizard;

import java.util.List;
import org.eclipse.app4mc.amalthea._import.atdb.ImportTransformation;
import org.eclipse.app4mc.amalthea._import.atdb.wizard.ImportPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportPage mainPage;
    private IStructuredSelection selection;

    public void addPages() {
        super.addPages();
        this.mainPage = new ImportPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)selection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle("Import AMALTHEA Model From AMALTHEA Trace Database");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final String source = this.mainPage.getSource();
        final IContainer target = this.mainPage.getTargetContainer();
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ImportTransformation transformer = new ImportTransformation(source, target);
                            transformer.run(progressMonitor);
                            target.refreshLocal(1, progressMonitor);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        IProject project = target.getProject();
        int from = Math.max(source.lastIndexOf(47), source.lastIndexOf(92));
        int to = source.lastIndexOf(".atdb");
        String name = String.valueOf(source.substring(from + 1, to)) + ".amxmi";
        IFile file = project.getFile(name);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return true;
    }
}

