/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.repair;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RepresentationFilesNeedCloseSessionValidator {
    private static final int OPERATION_CANCELED = 0;
    private String actionName;

    public RepresentationFilesNeedCloseSessionValidator(String actionName) {
        this.actionName = actionName;
    }

    public static String getMessageTitle(String actionName) {
        return MessageFormat.format(Messages.RepresentationFilesRepairValidator_confirmationDialogTitle, actionName);
    }

    public IStatus validate(IFile currentFileToMigrate) {
        IStatus resultStatus = null;
        Collection openedSessions = SessionManager.INSTANCE.getSessions();
        ArrayList<String> dirtySessionsName = new ArrayList<String>();
        if (openedSessions.size() > 0) {
            for (Session session : openedSessions) {
                if (SessionStatus.DIRTY != session.getStatus()) continue;
                dirtySessionsName.add(session.toString());
            }
            try {
                boolean saveSessions = this.userValidation(dirtySessionsName);
                this.closeSessions(saveSessions);
            }
            catch (CoreException e) {
                resultStatus = e.getStatus();
            }
        }
        if (resultStatus == null) {
            resultStatus = Status.OK_STATUS;
        }
        return resultStatus;
    }

    private boolean userValidation(Collection<String> dirtySessionsName) throws CoreException {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (shell == null) {
            shell = new Shell();
        }
        boolean saveSessions = false;
        StringBuffer message = new StringBuffer(MessageFormat.format(Messages.RepresentationFilesRepairValidator_launchImpossibleRepresentationsOpened, this.actionName));
        if (dirtySessionsName.size() > 0) {
            if (dirtySessionsName.size() == 1) {
                message.append(" ").append(Messages.RepresentationFilesRepairValidator_representationFileModified);
            } else {
                message.append(" ").append(Messages.RepresentationFilesRepairValidator_representationFilesModified);
            }
            for (String dirtySessionName : dirtySessionsName) {
                message.append(MessageFormat.format("\n\t- ''{0}'', ", dirtySessionName));
            }
            message.delete(message.length() - 2, message.length() - 1);
            message.append("\n\n").append(Messages.RepresentationFilesRepairValidator_askSave);
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(shell, RepresentationFilesNeedCloseSessionValidator.getMessageTitle(this.actionName), null, message.toString(), 3, buttons, 0);
            int result = dialog.open();
            if (result == -1 || buttons[result].equals(IDialogConstants.CANCEL_LABEL)) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.sirius.ui", 0, Messages.RepresentationFilesRepairValidator_migrationCanceled, null));
            }
            if (buttons[result].equals(IDialogConstants.YES_LABEL)) {
                saveSessions = true;
            }
        } else {
            message.append("\n").append(Messages.RepresentationFilesRepairValidator_askContinue);
            if (!MessageDialog.openConfirm((Shell)shell, (String)RepresentationFilesNeedCloseSessionValidator.getMessageTitle(this.actionName), (String)message.toString())) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.sirius.ui", 0, Messages.RepresentationFilesRepairValidator_migrationCanceled, null));
            }
        }
        return saveSessions;
    }

    private void closeSessions(boolean saveSessions) {
        Collection<IEditingSession> editingSessions = SessionUIManager.INSTANCE.getUISessions();
        for (IEditingSession editingSession : editingSessions) {
            editingSession.close(saveSessions);
        }
        ArrayList openedSessions = new ArrayList(SessionManager.INSTANCE.getSessions());
        for (Session session : openedSessions) {
            IEditingSession ui = SessionUIManager.INSTANCE.getUISession(session);
            if (ui != null) {
                ui.close(saveSessions);
                SessionUIManager.INSTANCE.remove(ui);
            }
            if (!session.isOpen()) continue;
            if (saveSessions) {
                session.save((IProgressMonitor)new NullProgressMonitor());
            }
            session.close((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

