/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugVariable;

public class EaseJavaFieldVariable
extends EaseDebugVariable {
    private final Object fBackingJavaObject;
    private final Field fField;

    private static Object convert(String expression, Class<? extends Object> clazz) {
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.parseInt(expression);
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            return Short.parseShort(expression);
        }
        if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
            return Byte.parseByte(expression);
        }
        if ((Character.TYPE.equals(clazz) || Character.class.equals(clazz)) && expression.length() == 1) {
            return Character.valueOf(expression.charAt(0));
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return Long.parseLong(expression);
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return Float.valueOf(Float.parseFloat(expression));
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return Double.parseDouble(expression);
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            return Boolean.parseBoolean(expression);
        }
        if (String.class.equals(clazz)) {
            return expression;
        }
        throw new IllegalArgumentException("Could not convert <" + expression + "> to " + clazz.getName());
    }

    private static boolean isSimpleType(Class<?> type) {
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return true;
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return true;
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return true;
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return true;
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return true;
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return true;
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return true;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return true;
        }
        return String.class.equals(type);
    }

    public EaseJavaFieldVariable(Field field, Object backingJavaObject, IDebugElement parent) throws IllegalArgumentException, IllegalAccessException {
        super(field.getName(), field.get(backingJavaObject), parent, null);
        this.fField = field;
        this.fBackingJavaObject = backingJavaObject;
        this.getValue().setParent(parent);
    }

    @Override
    public String getReferenceTypeName() {
        return this.fField.getType().getSimpleName();
    }

    @Override
    public EaseDebugVariable.Type getType() {
        return EaseDebugVariable.Type.JAVA_OBJECT;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.fField.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.fField.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.fField.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.fField.getModifiers());
    }

    @Override
    public void setValue(String expression) throws DebugException {
        try {
            Object value = EaseJavaFieldVariable.convert(expression, this.fField.getType());
            this.fField.set(this.fBackingJavaObject, value);
            this.getValue().update(value);
            if (this.getParent() instanceof EaseDebugStackFrame) {
                ((EaseDebugStackFrame)this.getParent()).fireChangeEvent(512);
            }
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.ease", "Could not set variable \"" + this.getName() + "\"", (Throwable)e));
        }
    }

    @Override
    public boolean supportsValueModification() {
        if (EaseJavaFieldVariable.isSimpleType(this.fField.getType())) {
            return !Modifier.isFinal(this.fField.getModifiers());
        }
        return false;
    }
}

