/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.LoginService;
import org.eclipse.egit.ui.internal.dialogs.CustomPromptDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EGitCredentialsProvider
extends CredentialsProvider {
    private String user;
    private String password;

    public EGitCredentialsProvider() {
    }

    public EGitCredentialsProvider(String user, String password) {
        this.user = user;
        this.password = password != null && password.isEmpty() ? null : password;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean get(final URIish uri, final CredentialItem ... items) throws UnsupportedCredentialItem {
        if (items.length == 0) {
            return true;
        }
        CredentialItem.Username userItem = null;
        CredentialItem.Password passwordItem = null;
        boolean isSpecial = false;
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem item = credentialItemArray[n2];
            if (item instanceof CredentialItem.Username) {
                userItem = (CredentialItem.Username)item;
            } else if (item instanceof CredentialItem.Password) {
                passwordItem = (CredentialItem.Password)item;
            } else {
                isSpecial = true;
            }
            ++n2;
        }
        if (!(isSpecial || userItem == null && passwordItem == null)) {
            UserPasswordCredentials credentials = null;
            credentials = this.user != null && this.password != null ? new UserPasswordCredentials(this.user, this.password) : SecureStoreUtils.getCredentials(uri);
            if (credentials == null && (credentials = this.getCredentialsFromUser(uri)) == null) {
                return false;
            }
            if (userItem != null) {
                userItem.setValue(credentials.getUser());
            }
            if (passwordItem != null) {
                passwordItem.setValue(credentials.getPassword().toCharArray());
            }
            return true;
        }
        final boolean[] result = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (items.length == 1) {
                    CredentialItem item = items[0];
                    result[0] = EGitCredentialsProvider.this.getSingleSpecial(shell, uri, item);
                } else {
                    result[0] = EGitCredentialsProvider.this.getMultiSpecial(shell, uri, items);
                }
            }
        });
        return result[0];
    }

    public void reset(URIish uri) {
        SecureStoreUtils.clearCredentials(uri);
        this.user = null;
        this.password = null;
    }

    private boolean getSingleSpecial(Shell shell, URIish uri, CredentialItem item) {
        if (item instanceof CredentialItem.InformationalMessage) {
            MessageDialog.openInformation((Shell)shell, (String)UIText.EGitCredentialsProvider_information, (String)item.getPromptText());
            return true;
        }
        if (item instanceof CredentialItem.YesNoType) {
            CredentialItem.YesNoType v = (CredentialItem.YesNoType)item;
            String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            int[] resultIDs = new int[]{2, 3, 1};
            MessageDialog dialog = new MessageDialog(shell, UIText.EGitCredentialsProvider_question, null, item.getPromptText(), 6, labels, 0);
            dialog.setBlockOnOpen(true);
            int r = dialog.open();
            if (r < 0) {
                return false;
            }
            switch (resultIDs[r]) {
                case 2: {
                    v.setValue(true);
                    return true;
                }
                case 3: {
                    v.setValue(false);
                    return true;
                }
            }
            return false;
        }
        return this.getMultiSpecial(shell, uri, item);
    }

    private boolean getMultiSpecial(Shell shell, URIish uri, CredentialItem ... items) {
        CustomPromptDialog dialog = new CustomPromptDialog(shell, uri, UIText.EGitCredentialsProvider_information, items);
        dialog.setBlockOnOpen(true);
        int r = dialog.open();
        return r == 0;
    }

    private UserPasswordCredentials getCredentialsFromUser(final URIish uri) {
        final AtomicReference<Object> aRef = new AtomicReference<Object>(null);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                aRef.set(LoginService.login(shell, uri));
            }
        });
        return aRef.get();
    }
}

