/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.executionmodel;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMCore;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTask;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskHistState;

public class ExecutionModel {
    private final Map<String, EMCore> cores = new HashMap<String, EMCore>();
    private final List<Consumer<EMCore>> coreAddedListener = new LinkedList<Consumer<EMCore>>();
    private final Map<String, EMTask> tasks = new HashMap<String, EMTask>();
    private final List<Consumer<EMTask>> taskAddedListener = new LinkedList<Consumer<EMTask>>();
    private final List<BiConsumer<EMTask, EMTaskHistState>> histEntryListener = new LinkedList<BiConsumer<EMTask, EMTaskHistState>>();
    private final List<BiConsumer<EMTask, EMTask.DeadlineEntry>> deadlineListener = new LinkedList<BiConsumer<EMTask, EMTask.DeadlineEntry>>();
    private EMTimeType timeScale = EMTimeType.NONE;
    private String path = "";

    public Map<String, EMCore> getCores() {
        return this.cores;
    }

    public Map<String, EMTask> getTasks() {
        return this.tasks;
    }

    public void setTimeScale(EMTimeType t) {
        this.timeScale = t;
    }

    public EMTimeType getTimeScale() {
        return this.timeScale;
    }

    public void addTaskDeadlineMissedEntry(String taskName, String core, Long time) {
        EMTask t = this.tasks.get(taskName);
        EMTask.DeadlineEntry d = new EMTask.DeadlineEntry(time, this.cores.get(core));
        t.getMissedDeadlines().add(d);
        this.notifyTaskDeadlineMissed(t, d);
    }

    public void addTaskHistEntry(String taskName, EMTaskHistState e) {
        EMTask t = this.tasks.get(taskName);
        t.getStateHistory().add(e);
        this.notifyTaskHistEntryListener(t, e);
    }

    public synchronized void addTask(EMTask t) {
        this.tasks.put(t.getName(), t);
        this.notifyTaskAddedListener(t);
    }

    public void addCore(EMCore c) {
        this.cores.put(c.getName(), c);
        this.notifyAllCoreAddedObserver(c);
    }

    private void notifyAllCoreAddedObserver(EMCore c) {
        this.coreAddedListener.forEach(x -> x.accept(c));
    }

    private void notifyTaskAddedListener(EMTask t) {
        this.taskAddedListener.forEach(x -> x.accept(t));
    }

    private void notifyTaskHistEntryListener(EMTask t, EMTaskHistState e) {
        this.histEntryListener.forEach(x -> x.accept(t, e));
    }

    public void addTaskHistEntryAddedListener(BiConsumer<EMTask, EMTaskHistState> e) {
        this.histEntryListener.add(e);
    }

    public void addTaskAddedListener(Consumer<EMTask> t) {
        this.taskAddedListener.add(t);
    }

    public void addCoreAddedListener(Consumer<EMCore> c) {
        this.coreAddedListener.add(c);
    }

    public void addTaskDeadlineListener(BiConsumer<EMTask, EMTask.DeadlineEntry> e) {
        this.deadlineListener.add(e);
    }

    private void notifyTaskDeadlineMissed(EMTask t, EMTask.DeadlineEntry e) {
        this.deadlineListener.forEach(x -> x.accept(t, e));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

