/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.executionmodel.types;

import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskEvent;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskState;

public class EMTaskFSM {
    private static final EMTaskState[][] multi = new EMTaskState[8][5];
    private EMTaskState currentState;

    static {
        EMTaskFSM.makeTransition(EMTaskState.RUNNING, EMTaskEvent.TERMINATE, EMTaskState.SUSPENDED);
        EMTaskFSM.makeTransition(EMTaskState.RUNNING, EMTaskEvent.PREEMPT, EMTaskState.READY);
        EMTaskFSM.makeTransition(EMTaskState.RUNNING, EMTaskEvent.WAIT, EMTaskState.WAITING);
        EMTaskFSM.makeTransition(EMTaskState.READY, EMTaskEvent.START, EMTaskState.RUNNING);
        EMTaskFSM.makeTransition(EMTaskState.WAITING, EMTaskEvent.RELEASE, EMTaskState.READY);
        EMTaskFSM.makeTransition(EMTaskState.SUSPENDED, EMTaskEvent.ACTIVATE, EMTaskState.READY);
    }

    private static void makeTransition(EMTaskState oldState, EMTaskEvent e, EMTaskState newState) {
        EMTaskFSM.multi[oldState.val()][e.val()] = newState;
    }

    public EMTaskFSM(EMTaskState start) {
        this.currentState = start;
    }

    public void setState(EMTaskState state) {
        this.currentState = state;
    }

    public EMTaskState getState() {
        return this.currentState;
    }

    public boolean dispatchEvent(EMTaskEvent event) {
        EMTaskState newState = multi[this.currentState.val()][event.val()];
        if (newState != null) {
            this.currentState = newState;
            return true;
        }
        return false;
    }
}

