/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;

public class OMRunnable {
    private final Runnable runnableRef;
    private long instructions = -1L;
    private final List<OMRunnable> post = new LinkedList<OMRunnable>();

    public OMRunnable(Runnable ref) {
        this.runnableRef = ref;
    }

    public Runnable getRunnableRef() {
        return this.runnableRef;
    }

    public long getInstructionCount() {
        if (this.runnableRef == null) {
            return 0L;
        }
        if (this.instructions >= 0L) {
            return this.instructions;
        }
        if (this.runnableRef.getRunnableItems().isEmpty()) {
            UniversalHandler.getInstance().log("Invalid Software Model, Runnable '" + this.runnableRef.getName() + "' contains no RunnableItems.", null);
            return 0L;
        }
        List totalTicks = SoftwareUtil.getTicks((Runnable)this.getRunnableRef(), null);
        this.instructions = totalTicks.stream().mapToLong(t -> t.getDefault().getUpperBound()).sum();
        return this.instructions;
    }

    public List<OMRunnable> getPost() {
        return this.post;
    }
}

