/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMRunnable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OMTask {
    private final Task taskRef;
    private OMTask predecessor = null;
    private long iInstructionCount = -1L;
    private final List<OMEdge> post = new LinkedList<OMEdge>();
    private List<OMRunnable> runnableSequence;
    private long period = -1L;

    public OMTask(Task taskRef) {
        this.taskRef = taskRef;
    }

    public OMTask(Task taskRef, OMTask predecessor) {
        this.taskRef = taskRef;
        this.predecessor = predecessor;
    }

    public Task getTaskRef() {
        return this.taskRef;
    }

    public OMTask getPredecessor() {
        return this.predecessor;
    }

    public long getInstructionCount() {
        if (0L > this.iInstructionCount) {
            this.getPropertyInstructionCount();
        }
        if (0L > this.iInstructionCount) {
            this.iInstructionCount = 0L;
            for (OMRunnable r : this.getRunnableCallSequence()) {
                this.iInstructionCount += r.getInstructionCount();
            }
        }
        return this.iInstructionCount;
    }

    private boolean getPropertyInstructionCount() {
        Object o;
        long val;
        EList a;
        Value x = (Value)this.getTaskRef().getCustomProperties().get((Object)"instructionCount");
        if (x != null && !(a = x.eClass().getEAttributes()).isEmpty() && (val = Long.parseLong((o = x.eGet((EStructuralFeature)a.get(0))).toString())) > 0L) {
            this.iInstructionCount = val;
            return true;
        }
        return false;
    }

    public long getRunnableCount() {
        return this.getRunnableCallSequence().size();
    }

    public String toString() {
        return this.taskRef.getUniqueName();
    }

    public long getPeriod() {
        if (this.period < 0L) {
            for (Stimulus s : this.getTaskRef().getStimuli()) {
                if (s instanceof PeriodicStimulus) {
                    PeriodicStimulus ps = (PeriodicStimulus)s;
                    Time x = ps.getRecurrence();
                    if (x == null) {
                        this.period = 0L;
                        return this.period;
                    }
                    long val = x.getValue().longValue();
                    if (val == 0L || x.getUnit() == null) {
                        this.period = 0L;
                        return this.period;
                    }
                    switch (x.getUnit()) {
                        case PS: {
                            val *= 1L;
                            break;
                        }
                        case NS: {
                            val *= 1000L;
                            break;
                        }
                        case US: {
                            val *= 1000000L;
                            break;
                        }
                        case MS: {
                            val *= 1000000000L;
                            break;
                        }
                        case S: {
                            val *= 1000000000000L;
                            break;
                        }
                        default: {
                            this.period = 0L;
                            return this.period;
                        }
                    }
                    this.period = val;
                    return this.period;
                }
                if (!(s instanceof RelativePeriodicStimulus)) continue;
                RelativePeriodicStimulus spst = (RelativePeriodicStimulus)s;
                ITimeDeviation dev = spst.getNextOccurrence();
                Time x = dev.getLowerBound();
                if (x == null) {
                    this.period = 0L;
                    return this.period;
                }
                long val = x.getValue().longValue();
                if (val == 0L || x.getUnit() == null) {
                    this.period = 0L;
                    return this.period;
                }
                switch (x.getUnit()) {
                    case PS: {
                        val *= 1L;
                        break;
                    }
                    case NS: {
                        val *= 1000L;
                        break;
                    }
                    case US: {
                        val *= 1000000L;
                        break;
                    }
                    case MS: {
                        val *= 1000000000L;
                        break;
                    }
                    case S: {
                        val *= 1000000000000L;
                        break;
                    }
                    default: {
                        this.period = 0L;
                        return this.period;
                    }
                }
                this.period = val;
                return this.period;
            }
            this.period = 0L;
        }
        return this.period;
    }

    public List<OMRunnable> getRunnableCallSequence() {
        if (this.runnableSequence == null) {
            try {
                this.runnableSequence = this.createCallSequenceList().stream().map(OMRunnable::new).collect(Collectors.toList());
            }
            catch (MalformedModelException malformedModelException) {
                this.runnableSequence = new LinkedList<OMRunnable>();
            }
        }
        return this.runnableSequence;
    }

    private List<Runnable> createCallSequenceList() throws MalformedModelException {
        LinkedList<Runnable> list = new LinkedList<Runnable>();
        Task t = this.getTaskRef();
        if (t == null) {
            throw new MalformedModelException("No Task defined!");
        }
        ActivityGraph graph = t.getActivityGraph();
        if (graph == null) {
            throw new MalformedModelException("No callgraph at task " + t.getName());
        }
        for (ActivityGraphItem entry : graph.getItems()) {
            if (!(entry instanceof Group)) continue;
            Group seq = (Group)entry;
            for (ActivityGraphItem item : seq.getItems()) {
                if (!(item instanceof RunnableCall)) continue;
                RunnableCall call = (RunnableCall)item;
                Runnable r = call.getRunnable();
                if (r == null) {
                    throw new MalformedModelException("Empty Runnable call at task " + t.getName());
                }
                list.add(r);
            }
            if (list.isEmpty()) {
                throw new MalformedModelException("Empty CallSequence at task " + t.getName());
            }
            return list;
        }
        throw new MalformedModelException("No CallSequence defined!");
    }

    public List<OMEdge> getPosts() {
        return this.post;
    }
}

