/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMRunnable;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;
import org.eclipse.emf.common.util.EList;

public class OMUtil {
    private OMUtil() {
    }

    public static OMMapping createOMMapping(MappingModel model) {
        EList allocations = model.getTaskAllocation();
        EList schedAllocs = model.getSchedulerAllocation();
        HashMap<ProcessingUnit, OMCore> cores = new HashMap<ProcessingUnit, OMCore>();
        HashMap<Scheduler, ProcessingUnit> schedToCore = new HashMap<Scheduler, ProcessingUnit>();
        for (SchedulerAllocation sa : schedAllocs) {
            ProcessingUnit c = (ProcessingUnit)sa.getResponsibility().get(0);
            Scheduler s = sa.getScheduler();
            schedToCore.put(s, c);
        }
        OMMapping m = new OMMapping();
        for (TaskAllocation ta : allocations) {
            Task t = ta.getTask();
            TaskScheduler s = ta.getScheduler();
            ProcessingUnit c = (ProcessingUnit)schedToCore.get(s);
            if (!cores.containsKey(c)) {
                cores.put(c, new OMCore(c));
            }
            OMAllocation alloc = new OMAllocation(new OMTask(t), (OMCore)cores.get(c));
            m.addAllocation(alloc);
        }
        return m;
    }

    public static Map<OMCore, List<OMTask>> getCoreTaskMap(List<OMAllocation> list) {
        return list.stream().collect(Collectors.groupingBy(OMAllocation::getCore, Collectors.mapping(OMAllocation::getTask, Collectors.toList())));
    }

    public static double getUtilization(OMCore c, List<OMTask> tasks) throws MalformedModelException {
        DoubleAdder d = new DoubleAdder();
        for (OMTask t : tasks) {
            if (t.getInstructionCount() <= 0L) {
                throw new MalformedModelException("Task " + t.getTaskRef().getName() + " instruction-count is lesser equal zero!");
            }
            d.add((double)OMUtil.getProcessingTime(c, t.getInstructionCount()) / (double)t.getPeriod());
        }
        return d.doubleValue();
    }

    public static long getMajorCycle(List<OMTask> tasks) {
        return OMUtil.lcm(tasks.parallelStream().map(OMTask::getPeriod).collect(Collectors.toList()));
    }

    private static long lcm(List<Long> values) {
        assert (values != null);
        assert (1 >= values.size());
        long result = values.get(0);
        long[] longArr = new long[values.size()];
        int i = 0;
        for (Long v : values) {
            longArr[i] = v;
            ++i;
        }
        OMUtil.lcm(longArr);
        return result;
    }

    private static long lcm(long a, long b) {
        return a * (b / OMUtil.gcd(a, b));
    }

    private static long lcm(long[] input) {
        long result = input[0];
        int i = 1;
        while (i < input.length) {
            result = OMUtil.lcm(result, input[i]);
            ++i;
        }
        return result;
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static long getReleaseInstructions(OMTask taskOfPre, OMRunnable ompre) {
        long overallInstructions = 0L;
        long releaseInstructions = 0L;
        for (OMRunnable r : taskOfPre.getRunnableCallSequence()) {
            overallInstructions += r.getInstructionCount();
            if (r != ompre) continue;
            releaseInstructions = overallInstructions;
        }
        return releaseInstructions;
    }

    public static long getProcessingTime(OMCore core, long instuctionCount) throws MalformedModelException {
        BigInteger ips = BigInteger.valueOf(core.getFrequencyHz());
        BigInteger ins = BigInteger.valueOf(instuctionCount);
        BigInteger psps = BigInteger.valueOf(1000000000000L);
        BigInteger computationTime = psps.multiply(ins).divide(ips);
        return computationTime.longValueExact();
    }

    public static boolean isDAG(Collection<OMEdge> edges) {
        return OMUtil.getTopologicallySoretedTasks(edges) != null;
    }

    public static List<OMTask> getTopologicallySoretedTasks(Collection<OMEdge> edges) {
        LinkedList<OMTask> resultList = new LinkedList<OMTask>();
        HashMap predecessorMap = new HashMap();
        for (OMEdge e : edges) {
            if (!predecessorMap.containsKey(e.getPost())) {
                predecessorMap.put(e.getPost(), new HashSet());
            }
            if (!predecessorMap.containsKey(e.getPre())) {
                predecessorMap.put(e.getPre(), new HashSet());
            }
            ((Set)predecessorMap.get(e.getPost())).add(e.getPre());
        }
        while (predecessorMap.size() > 0) {
            OMTask curTask = null;
            for (Map.Entry t : predecessorMap.entrySet()) {
                if (!((Set)t.getValue()).isEmpty()) continue;
                curTask = (OMTask)t.getKey();
                break;
            }
            if (curTask == null) {
                return null;
            }
            resultList.add(curTask);
            predecessorMap.remove(curTask);
            for (Set list : predecessorMap.values()) {
                list.remove(curTask);
            }
        }
        return resultList;
    }

    public static OMCore getCoreForTask(OMMapping mapping, OMTask t) {
        for (OMAllocation alloc : mapping.getAllocationList()) {
            if (alloc.getTask() != t) continue;
            return alloc.getCore();
        }
        return null;
    }
}

