/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMCore;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTask;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskEvent;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskHistState;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskState;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerEventListener;

public class EMTracer
implements ISchedulerEventListener {
    private final ExecutionModel executionModel;
    private final EMCore emCore;
    private final Map<String, EMTaskHistState> currentHist = new HashMap<String, EMTaskHistState>();

    public EMTracer(String coreName, ExecutionModel m) {
        this.executionModel = m;
        this.emCore = new EMCore(coreName);
        m.addCore(this.emCore);
    }

    @Override
    public void onTaskAdded(String taskName) {
        this.executionModel.addTask(new EMTask(taskName));
    }

    @Override
    public void onStartTask(String task, long time) {
        EMTaskHistState leaving = this.currentHist.get(task);
        if (leaving != null) {
            leaving.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leaving);
        }
        EMTaskHistState currentRunning = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.RUNNING, this.emCore);
        currentRunning.setStart(time);
        this.currentHist.put(task, currentRunning);
    }

    @Override
    public void onTerminateTask(String task, long time) {
        EMTaskHistState leavingRunning = this.currentHist.get(task);
        if (leavingRunning != null) {
            leavingRunning.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leavingRunning);
        }
        EMTaskHistState suspendedTask = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.SUSPENDED, this.emCore);
        suspendedTask.setStart(time);
        suspendedTask.setEvent(EMTaskEvent.TERMINATE);
        this.currentHist.put(task, suspendedTask);
    }

    @Override
    public void onPreemptTask(String task, long time) {
        EMTaskHistState leavingRunning = this.currentHist.get(task);
        if (leavingRunning != null) {
            leavingRunning.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leavingRunning);
        }
        EMTaskHistState readyTask = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.READY, this.emCore);
        readyTask.setStart(time);
        readyTask.setEvent(EMTaskEvent.PREEMPT);
        this.currentHist.put(task, readyTask);
    }

    @Override
    public void onStartIdleCore(long time) {
    }

    @Override
    public void onStopIdleCore(long time) {
    }

    @Override
    public void onActivateTask(String task, long time) {
        EMTaskHistState leavingSuspend = this.currentHist.get(task);
        if (leavingSuspend != null) {
            leavingSuspend.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leavingSuspend);
        }
        EMTaskHistState readyTask = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.READY, this.emCore);
        readyTask.setStart(time);
        readyTask.setEvent(EMTaskEvent.ACTIVATE);
        this.currentHist.put(task, readyTask);
    }

    @Override
    public void onWaitTask(String task, long time, String muxName, String holder) {
        EMTaskHistState leavingRunning = this.currentHist.get(task);
        if (leavingRunning != null) {
            leavingRunning.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leavingRunning);
        }
        EMTaskHistState waitingTask = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.WAITING, this.emCore);
        waitingTask.setStart(time);
        waitingTask.setEventCause(muxName);
        waitingTask.setNote(holder);
        this.currentHist.put(task, waitingTask);
    }

    @Override
    public void onReleaseTask(String task, long time) {
        EMTaskHistState leavingWaiting = this.currentHist.get(task);
        if (leavingWaiting != null) {
            leavingWaiting.setEnd(time);
            this.executionModel.addTaskHistEntry(task, leavingWaiting);
        }
        EMTaskHistState readyTask = EMTaskHistState.EMTaskHistStateFactory.create(EMTaskState.READY, this.emCore);
        readyTask.setStart(time);
        readyTask.setEvent(EMTaskEvent.RELEASE);
        this.currentHist.put(task, readyTask);
    }

    @Override
    public void onTaskMissedDeadline(String task, long time, long remainingExectime) {
        EMTaskHistState before = this.currentHist.get(task);
        if (before != null) {
            before.setEnd(time);
            this.executionModel.addTaskHistEntry(task, before);
            this.currentHist.remove(task);
        }
        this.executionModel.addTaskDeadlineMissedEntry(task, this.emCore.getName(), time);
    }

    @Override
    public String getCoreName() {
        return this.emCore.getName();
    }
}

