/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerAlgorithm;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerEventListener;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.ISchedulerBase;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.SchedulerTask;

public abstract class AbstractScheduler
implements ISchedulerBase {
    protected long simTime = 0L;
    private final Map<String, SchedulerTask> tasks = new HashMap<String, SchedulerTask>();
    private final List<ISchedulerEventListener> osHookListeners = new LinkedList<ISchedulerEventListener>();
    private final ISchedulerAlgorithm schedulingAlgo;
    protected SchedulerTask currentTask = null;

    public AbstractScheduler(ISchedulerAlgorithm m) {
        this.schedulingAlgo = m;
    }

    protected void notifyObserver(Consumer<? super ISchedulerEventListener> action) {
        this.osHookListeners.forEach(action);
    }

    protected Map<String, SchedulerTask> getTasks() {
        return this.tasks;
    }

    protected List<ISchedulerEventListener> getOsHookListeners() {
        return this.osHookListeners;
    }

    protected SchedulerTask getReadyPriorityTask() {
        SchedulerTask highTask = null;
        for (SchedulerTask t : this.tasks.values()) {
            if (!t.isReady() || highTask != null && this.compare(t, highTask) >= 0) continue;
            highTask = t;
        }
        return highTask;
    }

    @Override
    public long getSimTime() {
        return this.simTime;
    }

    protected void timeStep() {
        ++this.simTime;
    }

    protected boolean isPreemptiveScheduling() {
        return this.schedulingAlgo.isPreemptiveScheduling();
    }

    protected int compare(SchedulerTask t1, SchedulerTask t2) {
        int tmp = this.schedulingAlgo.compare(t1, t2);
        if (tmp == 0) {
            tmp = Integer.compare(t1.getId(), t2.getId());
        }
        return tmp;
    }

    @Override
    public SchedulerTask getTask(String name) {
        return this.getTasks().get(name);
    }

    @Override
    public void addTask(String name, long wcet, long period) {
        SchedulerTask t = new SchedulerTask(name, wcet, period);
        t.setId(this.getTasks().size());
        this.getTasks().put(t.getName(), t);
    }

    @Override
    public void addSchedulerEventListener(ISchedulerEventListener l) {
        this.getOsHookListeners().add(l);
    }
}

