/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerTask;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.Barrier;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.BarrierAccess;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.TaskFSM;

public class SchedulerTask
extends TaskFSM
implements ISchedulerTask {
    private final List<BarrierAccess> ownedBarriers = new LinkedList<BarrierAccess>();
    private final List<Barrier> dependentBarrier = new LinkedList<Barrier>();
    private final String name;
    private final long wcet;
    private final long period;
    private int periodCount = 0;
    private long esTime = 0L;
    private long currentExecTime = 0L;
    private int id;

    public SchedulerTask(String name, long wcet, long period) {
        super(TaskFSM.TState.READY);
        this.name = name;
        this.wcet = wcet;
        this.period = period;
        this.esTime = 0L;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getWCET() {
        return this.wcet;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    public int getPeriodCount() {
        return this.periodCount;
    }

    public void incrementPeriodCount() {
        ++this.periodCount;
    }

    public long getCurrentExecTime() {
        return this.currentExecTime;
    }

    public void run() {
        assert (this.isRunning());
        this.currentExecTime = Math.addExact(this.currentExecTime, 1L);
        assert (this.currentExecTime <= this.wcet);
    }

    public boolean reachedWCET() {
        return this.currentExecTime == this.wcet;
    }

    public long remainingExecutionTime() {
        return this.wcet - this.currentExecTime;
    }

    public void resetForNextPeriod() {
        this.currentExecTime = 0L;
        this.esTime += this.period;
        this.lockOwnedBarriers();
        this.incrementPeriodCount();
    }

    public long getEearliestStartTime() {
        return this.esTime;
    }

    public long getNextActivationTime() {
        return this.getEearliestStartTime() + this.period;
    }

    public boolean hasBlockingBarrier() {
        for (Barrier m : this.dependentBarrier) {
            if (!m.isLocked()) continue;
            return true;
        }
        return false;
    }

    public Barrier getFirstBlockingMutex() {
        for (Barrier m : this.dependentBarrier) {
            if (!m.isLocked()) continue;
            return m;
        }
        return null;
    }

    public long getDeadline() {
        return this.getEearliestStartTime() + this.getPeriod();
    }

    public void updateOwnedBarriers() {
        for (BarrierAccess ma : this.ownedBarriers) {
            long releaseTime = ma.getReleaseTime();
            assert (releaseTime <= this.getCurrentExecTime() || releaseTime == Long.MAX_VALUE);
            if (releaseTime == this.getCurrentExecTime()) {
                ma.getBarrier().unlock();
                continue;
            }
            if (releaseTime != Long.MAX_VALUE || !this.isSuspended()) continue;
            ma.getBarrier().unlock();
        }
    }

    public void lockOwnedBarriers() {
        for (BarrierAccess ma : this.ownedBarriers) {
            ma.getBarrier().tryLock(this.getName());
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void addOwnedBarrier(Barrier barrier, long releaseTime) {
        if (!barrier.tryLock(this.getName())) assert (false);
        BarrierAccess ma = new BarrierAccess(Long.MIN_VALUE, releaseTime, barrier);
        this.ownedBarriers.add(ma);
    }

    @Override
    public void addDependentBarrier(Barrier m) {
        this.dependentBarrier.add(m);
    }
}

