/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ClasspathUtils;

public class FXOsgiLaunchTask
extends Task {
    private String classpathRef;
    private String outDir;
    private String equinoxLauncherJarRef;
    private static final String PREFIX = "resources/classes/";
    private static final String[] LAUNCHER_FILES = new String[]{"com/javafx/main/Main.class", "com/javafx/main/Main$1.class", "com/javafx/main/Main$2.class", "com/javafx/main/NoJavaFXFallback.class"};

    public void setClasspathRef(String classpathRef) {
        this.classpathRef = classpathRef;
    }

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public void setEquinoxLauncherJarRef(String equinoxLauncherJarRef) {
        this.equinoxLauncherJarRef = equinoxLauncherJarRef;
    }

    public void execute() throws BuildException {
        try {
            ClassLoader cl = ClasspathUtils.getClassLoaderForPath((Project)this.getProject(), (Path)((Path)this.getProject().getReference(this.classpathRef)), (String)UUID.randomUUID().toString());
            FileSet p = (FileSet)this.getProject().getReference(this.equinoxLauncherJarRef);
            FileResource r = (FileResource)p.iterator().next();
            String equinoxLauncherJar = "plugins/" + r.getFile().getName();
            Manifest m = new Manifest();
            m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            m.getMainAttributes().put(new Attributes.Name("JavaFX-Version"), "2.2");
            m.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VENDOR, "BestSolution.at");
            m.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "JavaFX App");
            m.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, "1.0.0");
            m.getMainAttributes().put(new Attributes.Name("JavaFX-Application-Class"), "org.eclipse.equinox.launcher.Main");
            m.getMainAttributes().put(new Attributes.Name("JavaFX-Class-Path"), equinoxLauncherJar);
            m.getMainAttributes().put(new Attributes.Name("Main-Class"), "com/javafx/main/Main");
            FileOutputStream out = new FileOutputStream(new File(this.outDir, "fx-osgi-launcher.jar"));
            JarOutputStream jOut = new JarOutputStream((OutputStream)out, m);
            jOut.putNextEntry(new JarEntry("com/"));
            jOut.closeEntry();
            jOut.putNextEntry(new JarEntry("com/javafx/"));
            jOut.closeEntry();
            jOut.putNextEntry(new JarEntry("com/javafx/main"));
            jOut.closeEntry();
            String[] stringArray = LAUNCHER_FILES;
            int n = LAUNCHER_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                int len;
                String f = stringArray[n2];
                JarEntry e = new JarEntry(f);
                jOut.putNextEntry(e);
                byte[] buf = new byte[1024];
                InputStream in = cl.getResourceAsStream(PREFIX + f);
                while ((len = in.read(buf)) != -1) {
                    jOut.write(buf, 0, len);
                }
                jOut.closeEntry();
                ++n2;
            }
            jOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

