/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.text.DecimalFormat;
import java.util.stream.Collectors;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.SchedulerAlgorithmRegister;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TaskVisuSchedulingPage
extends WizardPage {
    private static final String[] SIM_TIME_INCREMENT = new String[]{"ms", "us", "ns", "ps"};
    private static final EMTimeType[] SIM_TIME_SCALE = new EMTimeType[]{EMTimeType.MS, EMTimeType.US, EMTimeType.NS, EMTimeType.PS};
    private Button button3;
    private Composite container;
    private Text txtSimuntil;
    private Combo cmbSchedulerSelection;
    private final OMMapping model;
    private long majorCycle = 0L;
    private long simuntil = 0L;
    private String scheduling = "";
    private EMTimeType timescale;
    private Combo cmbPrecessionSelection;
    private final XContainer con;

    protected TaskVisuSchedulingPage(IEMTraceWidget tw, OMMapping model, XContainer con) {
        super("Task Visualisation: Scheduling");
        this.con = con;
        this.model = model;
        this.setTitle("Task Visualisation: Scheduling");
        this.setDescription("Setup the scheduling used for the visualisation.");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.majorCycle = OMUtil.getMajorCycle(this.model.getAllocationList().stream().map(OMAllocation::getTask).collect(Collectors.toList()));
        Label lblMajorCycle = new Label(this.container, 0);
        lblMajorCycle.setText("Major-Cycle / Hyperperiod (ps)");
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        String numberAsString = decimalFormat.format(this.majorCycle);
        Label lbl_majorCycleVal = new Label(this.container, 0);
        lbl_majorCycleVal.setText(numberAsString);
        lbl_majorCycleVal.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (TaskVisuSchedulingPage.this.txtSimuntil != null) {
                    TaskVisuSchedulingPage.this.txtSimuntil.setText(String.valueOf(TaskVisuSchedulingPage.this.majorCycle));
                }
            }
        });
        Label lblSeconds = new Label(this.container, 0);
        lblSeconds.setText(" ");
        Label lblMajorCycleVal2 = new Label(this.container, 0);
        lblMajorCycleVal2.setText(this.psToString(this.majorCycle));
        Label label1 = new Label(this.container, 0);
        label1.setText("Algorithm");
        this.cmbSchedulerSelection = new Combo(this.container, 8);
        this.cmbSchedulerSelection.setItems(SchedulerAlgorithmRegister.schedulerList());
        this.cmbSchedulerSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = TaskVisuSchedulingPage.this.cmbSchedulerSelection.getSelectionIndex();
                if (i != -1) {
                    TaskVisuSchedulingPage.this.scheduling = SchedulerAlgorithmRegister.schedulerList()[i];
                    TaskVisuSchedulingPage.this.setPageComplete(TaskVisuSchedulingPage.this.isReadyToSim());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labeltimeinc = new Label(this.container, 0);
        labeltimeinc.setText("Scale to");
        this.cmbPrecessionSelection = new Combo(this.container, 8);
        this.cmbPrecessionSelection.setItems(SIM_TIME_INCREMENT);
        this.cmbPrecessionSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = TaskVisuSchedulingPage.this.cmbPrecessionSelection.getSelectionIndex();
                if (i != -1) {
                    TaskVisuSchedulingPage.this.timescale = SIM_TIME_SCALE[i];
                    TaskVisuSchedulingPage.this.setPageComplete(TaskVisuSchedulingPage.this.isReadyToSim());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelCheck = new Label(this.container, 0);
        labelCheck.setText("Simulation-Time (ps)");
        this.txtSimuntil = new Text(this.container, 0);
        this.simuntil = this.majorCycle;
        this.txtSimuntil.setText("" + this.majorCycle);
        this.txtSimuntil.addModifyListener(ev -> {
            String text = ((Text)ev.getSource()).getText();
            try {
                this.simuntil = Long.parseLong(text);
            }
            catch (NumberFormatException numberFormatException) {
                this.simuntil = 0L;
            }
            this.setPageComplete(this.isReadyToSim());
        });
        SelectionAdapter listenerDataFlow = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                System.out.print("DataFlow");
                System.out.println(" selected = " + button.getSelection());
                TaskVisuSchedulingPage.this.button3.setEnabled(button.getSelection());
                if (!button.getSelection()) {
                    TaskVisuSchedulingPage.this.con.setMergingArrow(false);
                    TaskVisuSchedulingPage.this.con.setAlternativeArrow(false);
                    TaskVisuSchedulingPage.this.button3.setSelection(false);
                }
                TaskVisuSchedulingPage.this.con.setDataFlow(button.getSelection());
            }
        };
        SelectionAdapter listenerMergeArrow = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                TaskVisuSchedulingPage.this.con.setMergingArrow(button.getSelection());
            }
        };
        Label labelDataflow = new Label(this.container, 0);
        labelDataflow.setText("Show Dataflow in Simulation:");
        Button button2 = new Button(this.container, 32);
        button2.setText("");
        button2.addSelectionListener((SelectionListener)listenerDataFlow);
        Label labelMergeArrow = new Label(this.container, 0);
        labelMergeArrow.setText("Extended Dataflow Simulation");
        this.button3 = new Button(this.container, 32);
        this.button3.setEnabled(false);
        this.button3.setText("");
        this.button3.addSelectionListener((SelectionListener)listenerMergeArrow);
        this.setControl((Control)this.container);
        this.setPageComplete(this.isReadyToSim());
    }

    private boolean isReadyToSim() {
        return this.simuntil != 0L && this.cmbSchedulerSelection != null && this.cmbSchedulerSelection.getSelectionIndex() != -1 && this.cmbPrecessionSelection != null && this.cmbPrecessionSelection.getSelectionIndex() != -1;
    }

    private String psToString(long ps) {
        if (ps % 1000L != 0L) {
            return String.valueOf(ps) + " ps";
        }
        if (ps % 1000000L != 0L) {
            return String.valueOf(ps / 1000L) + " ns";
        }
        if (ps % 1000000000L != 0L) {
            return String.valueOf(ps / 1000000L) + " us";
        }
        return String.valueOf(ps / 1000000000L) + " ms";
    }

    public long getSimuntil() {
        return this.simuntil;
    }

    public String getScheduling() {
        return this.scheduling;
    }

    public EMTimeType getTimeScale() {
        return this.timescale;
    }
}

