/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMRunnable;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.ISystemProxy;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SimException;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SystemProxyFactory;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.SchedulerAlgorithmRegister;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuDependencyPage;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuOverviewPage;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuSchedulingPage;
import org.eclipse.app4mc.multicore.execution.ui.traceview.TraceViewUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TaskVisuWizard
extends Wizard {
    protected TaskVisuOverviewPage page1;
    protected TaskVisuDependencyPage page2;
    protected TaskVisuSchedulingPage page3;
    protected IEMTraceWidget tw;
    protected OMMapping omModel;
    protected ConstraintsModel cm;
    private ISystemProxy systemProxy;
    XContainer con;
    private final String pa;

    public TaskVisuWizard(IEMTraceWidget tw, OMMapping model, ConstraintsModel cm, String path) {
        this.tw = tw;
        this.omModel = model;
        this.cm = cm;
        this.pa = path;
        this.con = XContainer.newInstance();
    }

    public void vievModel(OMMapping omM) {
        System.out.println("###############Start Inspection########################");
        for (OMAllocation tmp : omM.getAllocationList()) {
            OMTask ttp = tmp.getTask();
            Iterator list = ttp.getRunnableCallSequence().iterator();
            System.out.println(tmp.getCore() + " " + ttp);
            while (list.hasNext()) {
                System.out.println("### -> " + ((OMRunnable)list.next()).getRunnableRef().toString().split(" ")[2]);
            }
        }
        System.out.println("###############Start Inspection########################");
    }

    public String getWindowTitle() {
        return "Task Visualization Wizard";
    }

    public void addPages() {
        this.page1 = new TaskVisuOverviewPage(this.omModel);
        this.page2 = new TaskVisuDependencyPage(this.omModel, this.cm);
        this.page3 = new TaskVisuSchedulingPage(this.tw, this.omModel, this.con);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
    }

    public boolean performFinish() {
        final String sched = this.page3.getScheduling();
        final long schedtime = this.page3.getSimuntil();
        final EMTimeType timeScale = this.page3.getTimeScale();
        final Collection<OMEdge> taskPrecedence = this.page2.getTaskPrecedences();
        final boolean considerPrecedence = this.page2.considerTaskPrecedence();
        Job job = new Job("Task Visualisation Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ExecutionModel execResult = new ExecutionModel();
                    System.out.println(TaskVisuWizard.this.pa);
                    execResult.setPath(TaskVisuWizard.this.pa);
                    execResult.setTimeScale(timeScale);
                    TaskVisuWizard.this.systemProxy = SystemProxyFactory.createEMSystemProxyFromOMMapping((long)timeScale.picos(), (Supplier)SchedulerAlgorithmRegister.schedulerFactoryByName((String)sched), (OMMapping)TaskVisuWizard.this.omModel, (ExecutionModel)execResult);
                    if (considerPrecedence) {
                        for (OMEdge edge : taskPrecedence) {
                            OMCore preCore = OMUtil.getCoreForTask((OMMapping)TaskVisuWizard.this.omModel, (OMTask)edge.getPre());
                            OMCore postCore = OMUtil.getCoreForTask((OMMapping)TaskVisuWizard.this.omModel, (OMTask)edge.getPost());
                            long releaseTime = OMUtil.getProcessingTime((OMCore)preCore, (long)edge.getReleaseInstruction());
                            TaskVisuWizard.this.systemProxy.addTaskPrecedence(preCore.getCoreRef().getName(), edge.getPre().getTaskRef().getName(), releaseTime, postCore.getCoreRef().getName(), edge.getPost().getTaskRef().getName());
                        }
                    }
                    TaskVisuWizard.this.tw.addExecutionModel(execResult);
                    System.err.println("STARTING SIM");
                    long cur = System.currentTimeMillis();
                    TaskVisuWizard.this.systemProxy.compute(schedtime);
                    monitor.done();
                    System.out.println("Finish");
                    TaskVisuWizard.this.tw.setFinish();
                    if (TaskVisuWizard.this.con.isDataFlow() && !TaskVisuWizard.this.con.isMergingArrow()) {
                        JOptionPane.showMessageDialog(null, "Report:\n" + TaskVisuWizard.this.con.getReport());
                    }
                    if (TaskVisuWizard.this.con.isMergingArrow() && TaskVisuWizard.this.con.isDataFlow()) {
                        TaskVisuWizard.this.renderBetterReport(TaskVisuWizard.this.con);
                    }
                    System.err.println("READY duration:" + (System.currentTimeMillis() - cur));
                }
                catch (MalformedModelException | SimException e) {
                    e.printStackTrace();
                    TaskVisuWizard.getDisplay().asyncExec(new Runnable((Exception)e){
                        private final /* synthetic */ Exception val$e;
                        {
                            this.val$e = exception;
                        }

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)TraceViewUtil.getTraceViewPart().getSite().getShell(), (String)"Task Visualization", (String)this.val$e.getMessage());
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                TaskVisuWizard.this.tw.setFinish();
                super.canceling();
                System.err.println("Canceling task visualization");
                if (TaskVisuWizard.this.systemProxy != null) {
                    TaskVisuWizard.this.systemProxy.interruptComputation();
                }
            }
        };
        job.schedule();
        return true;
    }

    private void renderBetterReport(final XContainer con) {
        Object[][] data;
        try {
            data = con.generateReport();
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "The data flow report could not be generated due to the missed goals", "Error", 0);
            return;
        }
        Object[] columnNames = new Object[]{"Name", "Total Execution", "Oversampling Exe.", "Undersampling Exe."};
        final JDialog dialog = new JDialog();
        JPanel contentPanel = new JPanel();
        dialog.setAlwaysOnTop(true);
        dialog.setResizable(false);
        dialog.setBounds(100, 100, 700, 400);
        dialog.getContentPane().setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        dialog.getContentPane().add((Component)panel2, "North");
        Box verticalBox1 = Box.createVerticalBox();
        panel2.add(verticalBox1);
        Panel header = new Panel();
        verticalBox1.add(header);
        header.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblNewLabel = new JLabel("Report");
        header.add(lblNewLabel);
        Panel infoSpace = new Panel();
        verticalBox1.add(infoSpace);
        JLabel core = new JLabel("Cores:");
        infoSpace.add(core);
        JLabel coreCounter = new JLabel("" + con.getCores().size());
        coreCounter.setForeground(Color.RED);
        infoSpace.add(coreCounter);
        JLabel runnable = new JLabel("Runnables:");
        infoSpace.add(runnable);
        JLabel runnableCounter = new JLabel("" + con.getRunnables().size());
        runnableCounter.setForeground(Color.RED);
        infoSpace.add(runnableCounter);
        JLabel labels = new JLabel("Labels:");
        infoSpace.add(labels);
        JLabel label = new JLabel("" + con.getLabels().size());
        label.setForeground(Color.RED);
        infoSpace.add(label);
        Panel panel = new Panel();
        verticalBox1.add(panel);
        JLabel globalChain = new JLabel("Global Eventchain:");
        panel.add(globalChain);
        JLabel lblGlobalChain = new JLabel("" + con.isHaveglobal());
        lblGlobalChain.setForeground(Color.RED);
        panel.add(lblGlobalChain);
        JTable table = new JTable(data, columnNames){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = this.getPreferredSize();
                int n = this.getRowHeight();
                return new Dimension(d.width * 2, n * con.getCores().size());
            }
        };
        JScrollPane sp = new JScrollPane(table);
        verticalBox1.add(contentPanel);
        contentPanel.setLayout(new FlowLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPanel.add(sp);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        dialog.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                dialog.setVisible(false);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

