/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ecore.EcoreDiagramHelper;
import net.sourceforge.plantuml.text.AbstractClassDiagramTextProvider;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractEcoreClassDiagramTextProvider
extends AbstractClassDiagramTextProvider {
    private static final String DEFAULT_EXTERNAL_STEREOTYPE = null;
    protected final EcoreDiagramHelper diagramHelper = new EcoreDiagramHelper();
    private final int maxResourceCount = 1;
    private final int maxPackageCount = 1;
    private final Collection<String> excludePackages = Arrays.asList(new String[0]);
    private Map<String, String> skinParams = null;
    private List<EClassifier> classifiers;
    private final boolean suppressSingleMultiplicity = true;

    protected AbstractEcoreClassDiagramTextProvider(Class<?> editorType) {
        super(editorType);
    }

    protected AbstractEcoreClassDiagramTextProvider() {
        this(IEditingDomainProvider.class);
    }

    public boolean supportsSelection(ISelection selection) {
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return this.supportsEObject((EObject)firstElement);
        }
        return false;
    }

    protected boolean supportsEObject(EObject selection) {
        return AbstractEcoreClassDiagramTextProvider.isEcoreClassDiagramObject(selection);
    }

    protected EPackage getEPackage(EObject selection) {
        return this.diagramHelper.getAncestor(selection, EPackage.class);
    }

    public static boolean isEcoreClassDiagramObject(Object object) {
        return object instanceof EModelElement;
    }

    protected String getDiagramText(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        if (selection instanceof IStructuredSelection) {
            EPackage ePack;
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof EObject && this.supportsEObject((EObject)sel) && (ePack = this.getEPackage((EObject)sel)) != null) {
                return this.getDiagramText(this.getEPackage((EObject)ePack));
            }
            return null;
        }
        return this.getDiagramText(((IEditingDomainProvider)editorPart).getEditingDomain().getResourceSet());
    }

    protected String getDiagramText(ResourceSet resourceSet) {
        int resourceCount = 0;
        int packageCount = 0;
        this.classifiers = new ArrayList<EClassifier>();
        block0: for (Resource resource : resourceSet.getResources()) {
            EPackage pack = null;
            for (EObject root : resource.getContents()) {
                pack = this.getEPackage(root);
                if (pack == null || this.excludePackages.contains(pack.getNsURI())) continue;
                this.init(pack);
                if (++packageCount == 1) break block0;
            }
            if (pack != null && ++resourceCount == 1) break;
        }
        String result = this.classifiers.size() > 0 ? this.getDiagramText(GEN_MEMBERS | GEN_EXTENDS | GEN_IMPLEMENTS | GEN_ASSOCIATIONS | GEN_CLASS_HYPERLINKS) : null;
        this.classifiers = null;
        return result;
    }

    protected String getDiagramText(EPackage pack) {
        this.classifiers = new ArrayList<EClassifier>();
        if (!this.excludePackages.contains(pack.getNsURI())) {
            this.init(pack);
        }
        String result = this.classifiers.size() > 0 ? this.getDiagramText(GEN_MEMBERS | GEN_EXTENDS | GEN_IMPLEMENTS | GEN_ASSOCIATIONS | GEN_CLASS_HYPERLINKS) : null;
        this.classifiers = null;
        return result;
    }

    private void init(EPackage pack) {
        this.addClassifiers(pack);
        this.skinParams = this.diagramHelper.getSkinParams((EModelElement)pack, this.skinParams);
    }

    protected void addClassifiers(EPackage pack) {
        TreeIterator it = pack.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof EClassifier)) continue;
            this.classifiers.add((EClassifier)eObject);
            it.prune();
        }
    }

    protected String getDiagramText(int genFlags) {
        StringBuilder buffer = new StringBuilder();
        if (this.skinParams != null) {
            this.appendSkinParams(this.skinParams, buffer);
        }
        for (EClassifier classifier : this.classifiers) {
            if (this.diagramHelper.shouldSuppress((ENamedElement)classifier, null)) continue;
            if (classifier instanceof EClass) {
                this.appendClass((EClass)classifier, genFlags, buffer);
                continue;
            }
            if (classifier instanceof EEnum) {
                this.appendEnum((EEnum)classifier, genFlags, buffer);
                continue;
            }
            if (!(classifier instanceof EDataType)) continue;
            this.appendDataType((EDataType)classifier, genFlags, buffer);
        }
        if (AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_EXTENDS}) || AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_IMPLEMENTS})) {
            for (EClassifier eClassifier : this.classifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass subClass = (EClass)eClassifier;
                for (EClass superClass : subClass.getESuperTypes()) {
                    if (this.diagramHelper.shouldSuppress((ENamedElement)superClass, "superType")) continue;
                    boolean isImplements = superClass.isInterface() && !subClass.isInterface();
                    int[] nArray = new int[1];
                    int n = nArray[0] = isImplements ? GEN_IMPLEMENTS : GEN_EXTENDS;
                    if (!AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])nArray)) continue;
                    this.appendGeneralisation(subClass, superClass, isImplements, buffer);
                }
            }
        }
        if (AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS})) {
            for (EClassifier eClassifier : this.classifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                for (EStructuralFeature feature : ((EClass)eClassifier).getEStructuralFeatures()) {
                    if (feature.getEType() == null || !(feature instanceof EReference) || this.diagramHelper.shouldSuppress((ENamedElement)feature, null) || this.diagramHelper.shouldSuppress((ENamedElement)feature.getEType(), "reference")) continue;
                    this.appendAssociation((EReference)feature, buffer);
                }
            }
        }
        return buffer.toString();
    }

    protected void appendGeneralisation(EClass subClass, EClass superClass, boolean isImplements, StringBuilder buffer) {
        String otherName = this.getOtherName((EClassifier)subClass, (EClassifier)superClass);
        this.appendGeneralisation(subClass.getName(), otherName, isImplements, buffer);
    }

    protected String getOtherName(EClassifier origin, EClassifier other) {
        String externalStereotype;
        String otherName = other.getName();
        if (!this.classifiers.contains(other) && (externalStereotype = this.diagramHelper.getAnnotation((EObject)origin, "externalStereotype", true, DEFAULT_EXTERNAL_STEREOTYPE)) != null && externalStereotype.length() > 0) {
            otherName = "<<" + externalStereotype + ">>";
        }
        return otherName;
    }

    protected String getClassifierColor(EClassifier classifier) {
        Map<String, String> skinParams = this.diagramHelper.getSkinParams((EModelElement)classifier, null);
        return skinParams != null ? skinParams.get("BackgroundColor") : null;
    }

    protected void appendClass(EClass eClass, int genFlags, StringBuilder buffer) {
        String modifiers = eClass.isAbstract() && !eClass.isInterface() ? "abstract" : null;
        String link = null;
        if (AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_CLASS_HYPERLINKS})) {
            link = this.diagramHelper.getEObjectHyperlink((EObject)eClass);
        }
        this.appendClassStart(modifiers, eClass.isInterface() ? "interface" : "class", eClass.getName(), link, this.getClassifierColor((EClassifier)eClass), buffer);
        if (AbstractEcoreClassDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_MEMBERS})) {
            EClassifier eType;
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                eType = feature.getEType();
                if (!(feature instanceof EAttribute) || this.diagramHelper.shouldSuppress((ENamedElement)feature, null) || eType != null && this.diagramHelper.shouldSuppress((ENamedElement)eType, "attribute")) continue;
                this.appendAttribute(null, null, this.getTypedName((ETypedElement)feature, "?"), feature.getName(), buffer);
            }
            for (EOperation op : eClass.getEOperations()) {
                eType = op.getEType();
                if (this.diagramHelper.shouldSuppress((ENamedElement)op, null) || eType != null && this.diagramHelper.shouldSuppress((ENamedElement)eType, "operation")) continue;
                ArrayList<String> parameters = new ArrayList<String>();
                for (EParameter parameter : op.getEParameters()) {
                    String paramString = parameter.getName();
                    if (parameter.getEType() != null) {
                        paramString = String.valueOf(parameter.getEType().getName()) + " " + paramString;
                    }
                    parameters.add(paramString);
                }
                this.appendOperation(null, null, this.getTypedName((ETypedElement)op, "void"), op.getName(), parameters, buffer);
            }
        }
        this.appendClassEnd(buffer);
    }

    protected void appendDataType(EDataType dataType, int genFlags, StringBuilder buffer) {
        this.appendClassStart(null, "class", dataType.getName(), this.getClassifierColor((EClassifier)dataType), buffer);
        if (dataType.getInstanceClassName() != null) {
            this.appendAttribute(null, null, null, dataType.getInstanceClassName(), buffer);
        }
        this.appendClassEnd(buffer);
    }

    protected void appendEnum(EEnum eEnum, int genFlags, StringBuilder buffer) {
        this.appendClassStart(null, "enum", eEnum.getName(), this.getClassifierColor((EClassifier)eEnum), buffer);
        for (EEnumLiteral literal : eEnum.getELiterals()) {
            this.appendAttribute(null, null, literal.getName(), literal.getLiteral(), buffer);
        }
        this.appendClassEnd(buffer);
    }

    protected String getTypedName(ETypedElement typed, String def) {
        EClassifier eType = typed.getEType();
        String typeName = this.getTypeName(eType, def);
        if (typed.isMany()) {
            typeName = String.valueOf(typeName) + "[]";
        }
        return this.getSimpleName(typeName);
    }

    protected String getTypeName(EClassifier type, String def) {
        String typeName = null;
        if (type != null) {
            if (type instanceof EDataType) {
                typeName = type.getInstanceClassName();
            }
            if (typeName == null) {
                typeName = type.getName();
            }
        } else {
            typeName = def;
        }
        return this.getSimpleName(typeName);
    }

    protected void appendAssociation(EReference ref, StringBuilder buffer) {
        EReference opposite = ref.getEOpposite();
        EClass sourceClass = ref.getEContainingClass();
        String source = sourceClass.getName();
        EClassifier targetType = ref.getEType();
        String target = this.getOtherName((EClassifier)sourceClass, targetType);
        String direction = this.diagramHelper.getAnnotation((EObject)ref, "direction", false, null);
        if (opposite != null) {
            int otherIndex = this.classifiers.indexOf(targetType);
            if (this.classifiers.indexOf(sourceClass) < otherIndex || otherIndex < 0) {
                this.appendAssociation(source, ref.isContainment(), opposite.getName(), this.getMultiplicity((EStructuralFeature)opposite), direction, target, opposite.isContainment(), ref.getName(), this.getMultiplicity((EStructuralFeature)ref), null, buffer);
            }
        } else {
            this.appendAssociation(source, ref.isContainment(), null, 0, direction, target, false, ref.getName(), this.getMultiplicity((EStructuralFeature)ref), null, buffer);
        }
    }

    protected int getMultiplicity(EStructuralFeature feature) {
        return feature.isMany() ? -1 : 0;
    }
}

