/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ecore;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.utils.MarkerLinkOpener;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EcoreDiagramHelper {
    public static String PLANTUML_ANNOTATION_KEY = "net.sourceforge.plantuml";
    public static String PLANTUML_SKINPARAMS_ANNOTATION_KEY = String.valueOf(PLANTUML_ANNOTATION_KEY) + "/skinparams";

    protected Map<String, String> getSkinParams(EModelElement element, Map<String, String> map) {
        for (EAnnotation annotation : element.getEAnnotations()) {
            String source = annotation.getSource();
            if (source == null || !source.startsWith(PLANTUML_SKINPARAMS_ANNOTATION_KEY)) continue;
            String key = source.substring(PLANTUML_SKINPARAMS_ANNOTATION_KEY.length());
            String qualifier = null;
            if (key.startsWith("/")) {
                qualifier = key.substring(1);
            }
            map = this.getSkinParams(qualifier, annotation, map);
        }
        return map;
    }

    protected Map<String, String> getSkinParams(String qualifier, EAnnotation annotation, Map<String, String> map) {
        EMap eMap;
        if (annotation != null && (eMap = annotation.getDetails()).size() > 0) {
            if (map == null) {
                map = new HashMap<String, String>();
            }
            for (String key : eMap.keySet()) {
                map.put(String.valueOf(qualifier != null ? qualifier : "") + key, (String)eMap.get((Object)key));
            }
        }
        return map;
    }

    protected String getAnnotation(EObject element, String key, boolean checkContainers, String def) {
        while (element instanceof EModelElement) {
            String value = EcoreUtil.getAnnotation((EModelElement)((EModelElement)element), (String)PLANTUML_ANNOTATION_KEY, (String)key);
            if (value != null) {
                return value;
            }
            if (!checkContainers) break;
            element = element.eContainer();
        }
        return def;
    }

    protected boolean checkAnnotation(EObject element, String key, boolean checkContainers) {
        return "true".equals(this.getAnnotation(element, key, checkContainers, null));
    }

    protected boolean shouldSuppress(EModelElement element, String name, String role) {
        String key = "suppress";
        String containerKey = String.valueOf(key) + name;
        if (role != null) {
            key = String.valueOf(key) + "As" + role;
            containerKey = String.valueOf(containerKey) + "As" + role;
        }
        return this.checkAnnotation((EObject)element, key, false) || this.checkAnnotation(element.eContainer(), containerKey, true);
    }

    protected boolean shouldSuppress(ENamedElement element, String role) {
        return this.shouldSuppress((EModelElement)element, element.getName(), role);
    }

    public <T> T getAncestor(EObject eObject, Class<T> clazz) {
        while (eObject != null) {
            if (clazz.isInstance(eObject)) {
                return (T)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public String getEObjectHyperlink(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        if (uri.isPlatformResource()) {
            String path = uri.path();
            String prefix = "/resource";
            if (path.startsWith("/resource")) {
                path = path.substring("/resource".length());
            }
            return MarkerLinkOpener.createMarkerLink((String)"org.eclipse.emf.ecore.diagnostic", (String)path, (String[])new String[]{"uri", URI.encodeQuery((String)uri.toString(), (boolean)false)});
        }
        return uri.toString();
    }
}

