/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters091.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.0", "output_model_version=0.9.1"}, service={IConverter.class})
public class CustomPropertiesConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPropertiesConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.0 to 0.9.1 : Executing CustomProperties converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateTimeObject(rootElement);
    }

    private void migrateTimeObject(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append(".//value[@xsi:type=\"am:TimeObject\"]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//values[@xsi:type=\"am:TimeObject\"]");
        List timeObjectElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element timeObjectElement : timeObjectElements) {
            Attribute typeAttribute = timeObjectElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (typeAttribute == null) continue;
            typeAttribute.setValue("am:Time");
        }
    }
}

