/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.EnumValueCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.QuickParser;

class EnumParser<T extends Enum<T>>
extends QuickParser<T> {
    private final Method methodValueOf;
    private final boolean isNullable;
    private final Class<T> enumClass;

    public static <T extends Enum<T>> EnumParser<T> create(Class<T> enumTypeClass, boolean isNullable) throws JsonProtocolModelParseException {
        return new EnumParser<T>(enumTypeClass, isNullable);
    }

    private EnumParser(Class<T> enumClass, boolean isNullable) throws JsonProtocolModelParseException {
        this.enumClass = enumClass;
        this.isNullable = isNullable;
        try {
            this.methodValueOf = enumClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new JsonProtocolModelParseException("Failed to find valueOf method for parsing strings", e);
        }
    }

    @Override
    public T parseValueQuick(Object value) throws JsonProtocolParseException {
        Enum result;
        if (this.isNullable && value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new JsonProtocolParseException("String value expected");
        }
        String stringValue = (String)value;
        stringValue = EnumValueCondition.decorateEnumConstantName(stringValue);
        try {
            result = (Enum)this.enumClass.cast(this.methodValueOf.invoke(null, stringValue));
        }
        catch (IllegalArgumentException e) {
            throw new JsonProtocolParseException("Failed to parse enum constant " + stringValue, e);
        }
        catch (IllegalAccessException e) {
            throw new JsonProtocolParseException("Failed to call valueOf method", e);
        }
        catch (InvocationTargetException e) {
            throw new JsonProtocolParseException("Failed to call valueOf method", e);
        }
        if (result == null) {
            throw new JsonProtocolParseException("Failed to parse value " + value + " as enum");
        }
        return (T)result;
    }

    @Override
    public void appendFinishedValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
        scope.append(this.enumClass.getCanonicalName());
    }

    @Override
    public void appendInternalValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
        this.appendFinishedValueTypeNameJava(scope);
    }

    @Override
    void writeParseQuickCode(JavaCodeGenerator.MethodScope scope, String valueRef, String resultRef) {
        T[] TArray = this.enumClass.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T constant = TArray[n2];
            String name = constant.toString();
            if (!name.toUpperCase().equals(name)) {
                throw new RuntimeException();
            }
            ++n2;
        }
        if (this.isNullable) {
            scope.startLine("if (" + valueRef + " == null) {\n");
            scope.startLine("  return null;\n");
            scope.startLine("}\n");
        }
        scope.startLine("if (" + valueRef + " instanceof String == false) {\n");
        scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"String value expected\");\n");
        scope.startLine("}\n");
        scope.startLine("String stringValue = (String) " + valueRef + ";\n");
        scope.startLine("stringValue = stringValue.toUpperCase();\n");
        scope.startLine(String.valueOf(this.enumClass.getCanonicalName()) + " " + resultRef + " = " + this.enumClass.getCanonicalName() + ".valueOf(");
        scope.append("stringValue);\n");
    }

    @Override
    boolean javaCodeThrowsException() {
        return true;
    }
}

