/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.xpath.utils.BulkXpathOperation;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeRefCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAttributeRefCacheBuilder.class);
    Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();

    @Override
    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    @Override
    public void clearCacheMap() {
        this.map.clear();
    }

    protected Map<String, Element> getAllElements_referred_by_URIFragments(File targetFile, Document rootDocument, String URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES) {
        Map uriFragment_schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES);
        if (uriFragment_schedulerRefAttribsMap == null) {
            LOGGER.error("cache : \"{}\" not populated", (Object)URIFRAGMENT_ELEMENT_REFS_ATTRIBUTES);
            return new HashMap<String, Element>();
        }
        Set<String> uriFragments = uriFragment_schedulerRefAttribsMap.keySet();
        Map<String, Element> uriFragment_ElementsMap = this.getAllElements_referred_by_URIFragments(rootDocument, uriFragments);
        return uriFragment_ElementsMap;
    }

    protected Map<String, Element> getAllElements_referred_by_URIFragments(Document rootDocument, Set<String> uriFragments) {
        HashMap<String, Element> uriFragment_ElementsMap = new HashMap<String, Element>();
        HashMap<String, String> uriFragment_XpathStringMap = new HashMap<String, String>();
        Map<Object, Object> xpath_ElementsMap = new HashMap();
        for (String uriFragment : uriFragments) {
            uriFragment_XpathStringMap.put(uriFragment, this.getXpathString(uriFragment));
        }
        BulkXpathOperation bulkXpathOperation = new BulkXpathOperation();
        xpath_ElementsMap = bulkXpathOperation.invokeXpath(rootDocument, uriFragment_XpathStringMap.values());
        for (String uriFragment : uriFragments) {
            if (uriFragment_ElementsMap.containsKey(uriFragment)) continue;
            String xpath = (String)uriFragment_XpathStringMap.get(uriFragment);
            List list = (List)xpath_ElementsMap.get(xpath);
            if (!list.isEmpty()) {
                uriFragment_ElementsMap.put(uriFragment, (Element)list.get(0));
                continue;
            }
            LOGGER.error("No references can be found for : {} corresponding Xpath used is : {}", (Object)uriFragment, (Object)xpath);
        }
        return uriFragment_ElementsMap;
    }

    protected void addAttributeTo_Href_URIFragment_Attributes_Cache(File targetFile, File refFile, String uriFragment_with_fileInfo, String fileNameInfo, String localURIFragment, Attribute attribute, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES) {
        Map reffile_uriFragment_schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
        HashMap table = (HashMap)reffile_uriFragment_schedulerRefAttribsMap.get(refFile);
        if (table == null) {
            table = new HashMap();
            reffile_uriFragment_schedulerRefAttribsMap.put(refFile, table);
        }
        HashMap<String, ArrayList<Attribute>> attributeMap = (HashMap<String, ArrayList<Attribute>>)table.get(uriFragment_with_fileInfo);
        ArrayList<Attribute> attributes = null;
        if (attributeMap == null) {
            attributeMap = new HashMap<String, ArrayList<Attribute>>();
            table.put(uriFragment_with_fileInfo, attributeMap);
        } else {
            attributes = (ArrayList<Attribute>)attributeMap.get(localURIFragment);
        }
        if (attributes == null) {
            attributes = new ArrayList<Attribute>();
            attributeMap.put(localURIFragment, attributes);
        }
        attributes.add(attribute);
    }

    protected String getXpathString_old(String uriFragment) {
        if ((uriFragment = uriFragment.replace("@", "")).contains(".")) {
            int lastIndexOf = uriFragment.lastIndexOf(46);
            String substring = uriFragment.substring(lastIndexOf + 1);
            try {
                int arrayIndex = Integer.parseInt(substring) + 1;
                uriFragment = String.valueOf(uriFragment.substring(0, lastIndexOf)) + "[" + arrayIndex + "]";
            }
            catch (Exception e) {
                LOGGER.error("Exception occured during conversion of URIFragment : {} to Xpath String", (Object)uriFragment, (Object)e);
                throw e;
            }
        }
        return uriFragment;
    }

    protected String getXpathString(String uriFragment) {
        if ((uriFragment = uriFragment.replace("@", "")).contains(".")) {
            char[] charArray = uriFragment.toCharArray();
            boolean isBuildingIndex = false;
            StringBuilder xpathBuffer = new StringBuilder();
            StringBuilder indexBuffer = new StringBuilder();
            int i = 0;
            while (i < charArray.length) {
                if (charArray[i] == '.') {
                    xpathBuffer.append("[");
                    isBuildingIndex = true;
                    indexBuffer = new StringBuilder();
                } else if (isBuildingIndex && charArray[i] == '/') {
                    this.addIndexToBuffer(xpathBuffer, indexBuffer);
                    indexBuffer = new StringBuilder();
                    xpathBuffer.append("]");
                    xpathBuffer.append("/");
                    isBuildingIndex = false;
                } else if (isBuildingIndex) {
                    indexBuffer.append(charArray[i]);
                } else {
                    xpathBuffer.append(charArray[i]);
                }
                ++i;
            }
            if (isBuildingIndex) {
                this.addIndexToBuffer(xpathBuffer, indexBuffer);
                xpathBuffer.append("]");
            }
            uriFragment = xpathBuffer.toString();
        }
        return uriFragment;
    }

    private void addIndexToBuffer(StringBuilder xpathBuffer, StringBuilder indexBuffer) {
        try {
            long parseLong = Long.parseLong(indexBuffer.toString());
            xpathBuffer.append(parseLong + 1L);
        }
        catch (Exception e) {
            xpathBuffer.append((CharSequence)indexBuffer);
        }
    }

    protected Map<String, List<Attribute>> getAllAttributes_containing_URIFragments(Document rootDocument, String xPath_for_attributes, Namespace ... nameSpaces) {
        List<Attribute> schedulerAttributes = HelperUtil.getXpathResult(rootDocument, xPath_for_attributes, Attribute.class, nameSpaces);
        HashMap<String, List<Attribute>> uriFragment_AttributesMap = new HashMap<String, List<Attribute>>();
        for (Attribute attribute : schedulerAttributes) {
            String uriFragment = attribute.getValue();
            if (!uriFragment_AttributesMap.containsKey(uriFragment)) {
                uriFragment_AttributesMap.put(uriFragment, new ArrayList());
            }
            ((List)uriFragment_AttributesMap.get(uriFragment)).add(attribute);
        }
        return uriFragment_AttributesMap;
    }

    protected void populateAllHREF_ElementAttributes_having_legacy_URI_refs(File targetFile, Document rootDocument, String xpath_elementtype_href_attribute, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, Namespace ... namespaces) {
        List<Attribute> schedulerHrefs = HelperUtil.getXpathResult(rootDocument, xpath_elementtype_href_attribute, Attribute.class, namespaces);
        HashMap<String, File> refFileInfoMap = new HashMap<String, File>();
        HashMap reffile_uriFragment_schedulerRefAttribsMap = new HashMap();
        this.getCacheMap().get(targetFile).put(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, reffile_uriFragment_schedulerRefAttribsMap);
        for (Attribute attribute : schedulerHrefs) {
            String uriFragment_with_fileInfo = attribute.getValue();
            int indexOfHash = uriFragment_with_fileInfo.indexOf(35);
            if (indexOfHash == -1) continue;
            String fileNameInfo = uriFragment_with_fileInfo.substring(0, indexOfHash);
            String localURIFragment = uriFragment_with_fileInfo.substring(indexOfHash + 1);
            if (!localURIFragment.contains("//")) continue;
            File refFile = this.getRefFile(targetFile, refFileInfoMap, fileNameInfo);
            if (refFile != null) {
                this.addAttributeTo_Href_URIFragment_Attributes_Cache(targetFile, refFile, uriFragment_with_fileInfo, fileNameInfo, localURIFragment, attribute, HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
                continue;
            }
            LOGGER.error("Skipping attribut with value : {}", (Object)uriFragment_with_fileInfo);
        }
    }

    protected File getRefFile(File targetFile, HashMap<String, File> refFileInfoMap, String fileNameInfo) {
        File referredFile = null;
        if (!refFileInfoMap.containsKey(fileNameInfo)) {
            referredFile = new File(fileNameInfo);
            if (!referredFile.exists() && !(referredFile = new File(targetFile.getParent(), fileNameInfo)).exists()) {
                referredFile = null;
                LOGGER.error("Unable to find the referred file : {}", (Object)fileNameInfo);
            }
            refFileInfoMap.put(fileNameInfo, referredFile);
        } else {
            referredFile = refFileInfoMap.get(fileNameInfo);
        }
        return referredFile;
    }

    protected void populate_All_UUID_Elements(File targetFile, Document rootDocument, String xpath, String UUID_ELEMENT, Namespace ... nameSpaces) {
        Map<String, Element> uuid_element_map = null;
        if (!this.getCacheMap().get(targetFile).containsKey(UUID_ELEMENT)) {
            uuid_element_map = new HashMap();
            this.getCacheMap().get(targetFile).put(UUID_ELEMENT, uuid_element_map);
        } else {
            uuid_element_map = (Map)this.getCacheMap().get(targetFile).get(UUID_ELEMENT);
        }
        List<Element> elements = HelperUtil.getXpathResult(rootDocument, xpath, Element.class, nameSpaces);
        for (Element element : elements) {
            Attribute attribute = element.getAttribute("id", AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
            if (attribute == null) continue;
            uuid_element_map.put(attribute.getValue(), element);
        }
    }

    protected void populate_All_Elements_With_Name(File targetFile, Document rootDocument, String xpath, String ELEMENT_NAME, Namespace ... nameSpaces) {
        Map<String, Element> name_element_map = null;
        if (!this.getCacheMap().get(targetFile).containsKey(ELEMENT_NAME)) {
            name_element_map = new HashMap();
            this.getCacheMap().get(targetFile).put(ELEMENT_NAME, name_element_map);
        } else {
            name_element_map = (Map)this.getCacheMap().get(targetFile).get(ELEMENT_NAME);
        }
        List<Element> elements = HelperUtil.getXpathResult(rootDocument, xpath, Element.class, nameSpaces);
        for (Element element : elements) {
            Attribute attribute = element.getAttribute("name");
            if (attribute == null) continue;
            name_element_map.put(attribute.getValue(), element);
        }
    }

    protected void populate_AllElements_referred_by_hrefURIFragments(File targetFile, Document rootDocument, Map<File, Document> fileName_documentsMap, String HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES, String HREF_URIFRAGMENT_ELEMENT) {
        Map reffile_uriFragment_schedulerRefAttribsMap = (Map)this.getCacheMap().get(targetFile).get(HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES);
        Set keySet = reffile_uriFragment_schedulerRefAttribsMap.keySet();
        HashMap<String, Element> allElements_referred_by_URIFragments = new HashMap<String, Element>();
        this.getCacheMap().get(targetFile).put(HREF_URIFRAGMENT_ELEMENT, allElements_referred_by_URIFragments);
        for (File referencedFile : keySet) {
            Document targetDocument = fileName_documentsMap.get(referencedFile);
            Map table = (Map)reffile_uriFragment_schedulerRefAttribsMap.get(referencedFile);
            HashMap<String, String> local_uriFragment_global_uriFragment_Map = new HashMap<String, String>();
            HashMap<String, String> local_uriFragment_Xpath_Map = new HashMap<String, String>();
            Map<Object, Object> xpath_ElementsMap = new HashMap();
            for (Map.Entry entry : table.entrySet()) {
                String row_globalURI = (String)entry.getKey();
                Map rowMap = (Map)entry.getValue();
                Set columns = rowMap.keySet();
                if (columns == null || columns.isEmpty()) continue;
                for (String column_localURI : columns) {
                    local_uriFragment_global_uriFragment_Map.put(column_localURI, row_globalURI);
                    local_uriFragment_Xpath_Map.put(column_localURI, this.getXpathString(column_localURI));
                }
            }
            BulkXpathOperation bulkXpathOperation = new BulkXpathOperation();
            xpath_ElementsMap = bulkXpathOperation.invokeXpath(targetDocument, local_uriFragment_Xpath_Map.values());
            for (Map.Entry entry : local_uriFragment_Xpath_Map.entrySet()) {
                String local_uri = (String)entry.getKey();
                String xpath = (String)entry.getValue();
                String global_uri = (String)local_uriFragment_global_uriFragment_Map.get(local_uri);
                List elements = (List)xpath_ElementsMap.get(xpath);
                if (!elements.isEmpty()) {
                    allElements_referred_by_URIFragments.put(global_uri, (Element)elements.get(0));
                    continue;
                }
                LOGGER.error("Element could not be found for URI : {}", (Object)global_uri);
            }
        }
    }
}

