/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;

public class OutputPathParser {
    public static final String DEFAULT_OUTPUT = "0";
    public static final String RELATIVE_OUTPUT = "1";
    public static final String ABSOLUTE_OUTPUT = "2";
    private String radioPreferenceName;
    private String pathPreferenceName;
    private IPreferenceStore store;

    public OutputPathParser(String radioPreferenceName, String pathPreferenceName, IPreferenceStore store) {
        this.radioPreferenceName = radioPreferenceName;
        this.pathPreferenceName = pathPreferenceName;
        this.store = store;
    }

    public String parseOutputDirectory(String projectPath) {
        String radioOutputDirectory = this.store.getString(this.radioPreferenceName);
        String sOutputDirectory = this.store.getString(this.pathPreferenceName);
        switch (radioOutputDirectory) {
            case "0": {
                return String.valueOf(projectPath) + "/" + this.store.getDefaultString(this.pathPreferenceName) + "/";
            }
            case "1": {
                return String.valueOf(projectPath) + "/" + sOutputDirectory + "/";
            }
            case "2": {
                return String.valueOf(sOutputDirectory) + "/";
            }
        }
        return String.valueOf(projectPath) + "/";
    }

    public String parseOutputDirectoryGeneric() {
        return this.parseOutputDirectory("{ProjectRoot}");
    }

    public URI parseOutputFileURI(IFile sorceFile, String append) {
        String projectPath = sorceFile.getProject().getFullPath().toString();
        String radioOutputDirectory = this.store.getString(this.radioPreferenceName);
        String newFileName = sorceFile.getName().replace(".amxmi", String.valueOf(append) + ".amxmi");
        switch (radioOutputDirectory) {
            case "0": 
            case "1": {
                return URI.createPlatformResourceURI((String)(String.valueOf(this.parseOutputDirectory(projectPath)) + newFileName), (boolean)true);
            }
            case "2": {
                return URI.createFileURI((String)(String.valueOf(this.parseOutputDirectory(projectPath)) + newFileName));
            }
        }
        return URI.createFileURI((String)(String.valueOf(this.parseOutputDirectory(projectPath)) + newFileName));
    }
}

