/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.ConfigModel;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaResourceFactory;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.LogView;
import org.eclipse.app4mc.multicore.sharelibs.utframework.TestUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class UniversalHandler {
    private boolean verboseOutputEnable = false;
    private String pluginId = "ERR_PLUGINID_UNSET";
    private ILog iLog;
    private Logger aLog;
    private Amalthea centralModel;
    private final Map<String, EObject> cache = new HashMap<String, EObject>();
    private final Map<URI, Resource> cache2 = new HashMap<URI, Resource>();
    private LogView modelCheckerView;

    public static UniversalHandler getInstance() {
        return UniversalHandlerHolder.UH_INSTANCE;
    }

    UniversalHandler() {
        try {
            AmaltheaPackage.eINSTANCE.eClass();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!TestUtil.isTesting() && PlatformUI.isWorkbenchRunning()) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                window.getActivePage();
            }
        }
        catch (Exception e) {
            System.out.println("Warning! Not possible to show model checker view");
            e.printStackTrace();
        }
    }

    public boolean writeFile(IPath path, StringBuilder string) {
        IFile outFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        File parentFolder = new File(outFile.getParent().getFullPath().toOSString());
        parentFolder.mkdirs();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(string.toString().getBytes(StandardCharsets.UTF_8));){
                if (outFile.exists()) {
                    outFile.setContents((InputStream)stream, true, true, null);
                } else {
                    outFile.create((InputStream)stream, true, null);
                }
                stream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void readModels(URI uri, boolean copyModel) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory(true));
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        try {
            Resource res = resSet.createResource(uri);
            res.load(null);
            Object content = copyModel ? copier.copyAll((Collection)res.getContents()) : res.getContents();
            this.setModel((Collection<EObject>)content);
        }
        catch (IOException | WrappedException e) {
            e.printStackTrace();
        }
        if (copyModel) {
            copier.copyReferences();
        }
    }

    public void writeModel(URI uri, EObject model) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory(true));
        resSet.setURIResourceMap(this.cache2);
        Resource resource = resSet.createResource(uri);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(this.cache);
        IFile outFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()));
        File parentFolder = new File(outFile.getParent().getFullPath().toOSString());
        parentFolder.mkdirs();
        try {
            resource.getContents().add((Object)model);
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeModel(URI uri, List<EObject> models) {
        Amalthea containerModel = AmaltheaFactory.eINSTANCE.createAmalthea();
        for (EObject model : models) {
            if (model instanceof CommonElements) {
                containerModel.setCommonElements((CommonElements)model);
                continue;
            }
            if (model instanceof SWModel) {
                containerModel.setSwModel((SWModel)model);
                continue;
            }
            if (model instanceof HWModel) {
                containerModel.setHwModel((HWModel)model);
                continue;
            }
            if (model instanceof ConstraintsModel) {
                containerModel.setConstraintsModel((ConstraintsModel)model);
                continue;
            }
            if (model instanceof MappingModel) {
                containerModel.setMappingModel((MappingModel)model);
                continue;
            }
            if (model instanceof StimuliModel) {
                containerModel.setStimuliModel((StimuliModel)model);
                continue;
            }
            if (model instanceof OSModel) {
                containerModel.setOsModel((OSModel)model);
                continue;
            }
            if (model instanceof PropertyConstraintsModel) {
                containerModel.setPropertyConstraintsModel((PropertyConstraintsModel)model);
                continue;
            }
            if (model instanceof EventModel) {
                containerModel.setEventModel((EventModel)model);
                continue;
            }
            if (model instanceof ComponentsModel) {
                containerModel.setComponentsModel((ComponentsModel)model);
                continue;
            }
            if (!(model instanceof ConfigModel)) continue;
            containerModel.setConfigModel((ConfigModel)model);
        }
        this.writeModel(uri, (EObject)containerModel);
    }

    public void logCon(String message) {
        if (this.verboseOutputEnable) {
            System.out.println(message);
        }
    }

    public void log(String message) {
        this.log(message, null, 1);
    }

    public void logWarn(String message) {
        this.log(message, null, 2);
    }

    public void log(String message, Exception e) {
        this.log(message, e, 4);
    }

    public void log(String message, Exception e, int severity) {
        this.logCon(message);
        if (this.getLog() == null) {
            if (this.aLog == null) {
                this.aLog = Logger.getLogger((String)this.pluginId);
            }
            switch (severity) {
                case 0: 
                case 1: 
                case 2: {
                    this.aLog.info((Object)message);
                    break;
                }
                case 4: 
                case 8: {
                    this.aLog.error((Object)message);
                }
            }
            if (e != null) {
                this.aLog.error((Object)("Exception: " + e));
            }
        } else {
            this.getLog().log((IStatus)new Status(severity, this.getPluginId(), 0, message, (Throwable)e));
        }
    }

    public void clearModelCheckerView() {
        if (this.modelCheckerView == null) {
            return;
        }
        this.modelCheckerView.flush();
    }

    public void showModelCheckerView() {
        this.modelCheckerView.setFocus();
    }

    public void enableVerboseOutput() {
        this.verboseOutputEnable = true;
    }

    public void setPluginId(String pluginId) {
        this.aLog = Logger.getLogger((String)pluginId);
        this.pluginId = pluginId;
    }

    public void setLog(ILog log) {
        if (log != null) {
            this.iLog = log;
        }
    }

    private String getPluginId() {
        return this.pluginId;
    }

    public Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    @Deprecated
    public static IStructuredSelection getSelection(ExecutionEvent event) {
        IStructuredSelection ssel = (IStructuredSelection)HandlerUtil.getActiveSite((ExecutionEvent)event).getSelectionProvider().getSelection();
        if (ssel == null) {
            return null;
        }
        return ssel;
    }

    @Deprecated
    private static Object getFirstSelection(ExecutionEvent event) {
        IStructuredSelection selection = UniversalHandler.getSelection(event);
        if (selection != null) {
            return selection.getFirstElement();
        }
        return null;
    }

    @Deprecated
    public static IFile getSelectedFile(ExecutionEvent event) {
        Object selection = UniversalHandler.getFirstSelection(event);
        if (selection instanceof IFile) {
            IFile file = (IFile)selection;
            return file;
        }
        return null;
    }

    @Deprecated
    public static URI getProjectDir(ExecutionEvent event) {
        Object selection = UniversalHandler.getFirstSelection(event);
        if (!(selection instanceof IResource)) {
            return null;
        }
        IResource file = (IResource)selection;
        String projectDir = file.getProject().getLocationURI().toString();
        return URI.createURI((String)projectDir);
    }

    private ILog getLog() {
        return this.iLog;
    }

    private void setModel(Collection<EObject> content) {
        if (content == null) {
            return;
        }
        for (EObject model : content) {
            if (!(model instanceof Amalthea)) continue;
            this.centralModel = (Amalthea)model;
        }
    }

    public CommonElements getCommonElements() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getCommonElements();
    }

    public SWModel getSwModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getSwModel();
    }

    public HWModel getHwModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getHwModel();
    }

    public ConstraintsModel getConstraintsModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getConstraintsModel();
    }

    public OSModel getOsModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getOsModel();
    }

    public StimuliModel getStimuliModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getStimuliModel();
    }

    public MappingModel getMappingModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getMappingModel();
    }

    public PropertyConstraintsModel getPropertyConstraintsModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getPropertyConstraintsModel();
    }

    public EventModel getEvModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getEventModel();
    }

    public ConfigModel getConfModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getConfigModel();
    }

    public ComponentsModel getComModel() {
        if (this.centralModel == null) {
            return null;
        }
        return this.centralModel.getComponentsModel();
    }

    public Amalthea getCentralModel() {
        return this.centralModel;
    }

    public void dropCache() {
        this.centralModel = null;
    }

    private static class UniversalHandlerHolder {
        public static final UniversalHandler UH_INSTANCE = new UniversalHandler();

        private UniversalHandlerHolder() {
        }
    }
}

