/**
 ********************************************************************************
 * Copyright (c) 2015-2020 Eclipse APP4MC contributors.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 ********************************************************************************
 */

package org.eclipse.app4mc.atdb.metrics;

import java.sql.SQLException;
import java.util.Collection;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MetricViewerContentProvider implements ITreeContentProvider {

	private final MetricViewer mv;

	public MetricViewerContentProvider(final MetricViewer mv) {
		this.mv = mv;
	}

	@Override
	public void dispose() {
		// do nothing
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// do nothing
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		if (inputElement instanceof Collection<?>) {
			return ((Collection<?>) inputElement).toArray();
		}
		return new Object[0];
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof Process) {
			try {
				return this.mv.dbAccess.calculateMetrcisForProcess((Process) parentElement).toArray();
			}
			catch (final SQLException e) {
				e.printStackTrace();
			}
		}
		return new Object[0];
	}

	@Override
	public Object getParent(final Object element) {
		return null;
	}

	@Override
	public boolean hasChildren(final Object element) {
		if (element instanceof Process) {
			return ((Process) element).hasEvents();
		}
		return false;
	}

}
