/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.nature;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaMetaModelDescriptor;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaWorkspaceEditingDomainMapping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class AmaltheaNoLoadNature
implements IProjectNature {
    public static final String ID = "amlt.no.load.nature";
    IProject project;

    public void configure() throws CoreException {
        AmaltheaNoLoadNature.unloadAmaltheaModelElementsFromProject(this.project);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void unloadAmaltheaModelElementsFromProject(IProject project) {
        WorkspaceEditingDomainManager workspaceEditingDomainManager = WorkspaceEditingDomainManager.INSTANCE;
        Method declaredMethod = null;
        try {
            declaredMethod = workspaceEditingDomainManager.getClass().getDeclaredMethod("getEditingDomainMapping", IMetaModelDescriptor.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        Object editingDomainMapping = null;
        if (declaredMethod != null) {
            if (declaredMethod.getName().equals("getEditingDomainMapping") && declaredMethod.getParameterCount() == 1) {
                try {
                    editingDomainMapping = declaredMethod.invoke((Object)workspaceEditingDomainManager, AmaltheaMetaModelDescriptor.INSTANCE);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Platform.getLog(AmaltheaNoLoadNature.class).log((IStatus)new Status(4, "org.eclipse.app4mc.amalthea.nature", "Error on retrieving the editing domain mapping", (Throwable)e));
                }
            }
        } else {
            editingDomainMapping = workspaceEditingDomainManager.getEditingDomainMapping();
        }
        if (editingDomainMapping instanceof AmaltheaWorkspaceEditingDomainMapping) {
            AmaltheaWorkspaceEditingDomainMapping mapping = (AmaltheaWorkspaceEditingDomainMapping)editingDomainMapping;
            List<IFile> filesInEditingDomain = AmaltheaNoLoadNature.getFilesInEditingDomain(project, mapping);
            AmaltheaNoLoadNature.closeEditors(filesInEditingDomain);
        }
    }

    private static List<IFile> getFilesInEditingDomain(IProject project, AmaltheaWorkspaceEditingDomainMapping domainMapping) {
        ArrayList<IFile> filesInEditingDomain = new ArrayList<IFile>();
        Map map = domainMapping.mappedEditingDomains;
        HashMap hashMap = (HashMap)map.get(AmaltheaMetaModelDescriptor.INSTANCE);
        if (hashMap != null) {
            Set keySet = hashMap.keySet();
            for (IContainer iContainer : keySet) {
                if (iContainer.getProject() != project) continue;
                TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)hashMap.get(iContainer);
                ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
                EList resources = resourceSet.getResources();
                for (Resource resource : resources) {
                    IFile file = EcorePlatformUtil.getFile((Resource)resource);
                    filesInEditingDomain.add(file);
                }
                EcorePlatformUtil.unloadResources((TransactionalEditingDomain)transactionalEditingDomain, (Collection)resources, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return filesInEditingDomain;
    }

    private static void closeEditors(List<IFile> filesInEditingDomain) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput editorInput;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(true);
            if (editor != null && (editorInput = editor.getEditorInput()) != null && filesInEditingDomain.contains(editorInput.getAdapter(IFile.class))) {
                activePage.closeEditor(editor, true);
            }
            ++n2;
        }
    }
}

