/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import java.math.BigInteger;
import java.util.Collection;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeHistogramEntry;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AmaltheaServices2 {
    private AmaltheaServices2() {
        throw new IllegalStateException("Utility class");
    }

    private static @NonNull Time createTime(BigInteger value, TimeUnit unit) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(value);
        time.setUnit(unit);
        return time;
    }

    private static boolean isInvalid(@NonNull Time time) {
        return time.getValue() == null || time.getUnit() == TimeUnit._UNDEFINED_;
    }

    private static @NonNull Time addTime(@NonNull Time t1, @NonNull Time t2) {
        return AmaltheaServices.addTime(t1, t2);
    }

    private static @NonNull Time subtractTime(@NonNull Time t1, @NonNull Time t2) {
        return AmaltheaServices.subtractTime(t1, t2);
    }

    private static @NonNull Time multiply(@NonNull Time t1, long value) {
        return AmaltheaServices.multiply(t1, value);
    }

    private static @NonNull Time multiply(@NonNull Time t1, double value) {
        return AmaltheaServices.multiply(t1, value);
    }

    private static int compareTimes(@NonNull Time t1, @NonNull Time t2) {
        return AmaltheaServices.compareTimes(t1, t2);
    }

    public static @Nullable Time getAverage(@Nullable Time lowerBound, @Nullable Time upperBound) {
        if (lowerBound == null || upperBound == null) {
            return null;
        }
        if (AmaltheaServices2.isInvalid(lowerBound) || AmaltheaServices2.isInvalid(upperBound)) {
            return null;
        }
        if (AmaltheaServices2.compareTimes(lowerBound, upperBound) > 0) {
            return null;
        }
        return AmaltheaServices2.addTime(lowerBound, AmaltheaServices2.multiply(AmaltheaServices2.subtractTime(upperBound, lowerBound), 0.5));
    }

    public static @Nullable Double getAverage(@Nullable Number lowerBound, @Nullable Number upperBound) {
        double upper;
        if (lowerBound == null || upperBound == null) {
            return null;
        }
        double lower = lowerBound.doubleValue();
        if (lower > (upper = upperBound.doubleValue())) {
            return null;
        }
        return lower + (upper - lower) / 2.0;
    }

    public static @Nullable Time getAverage_Time(@NonNull Collection<TimeHistogramEntry> coll) {
        long count = 0L;
        Time sum = AmaltheaServices2.createTime(BigInteger.ZERO, TimeUnit.PS);
        for (TimeHistogramEntry entry : coll) {
            if (entry == null) {
                return null;
            }
            Time avg = AmaltheaServices2.getAverage(entry.getLowerBound(), entry.getUpperBound());
            if (avg == null) {
                return null;
            }
            count += entry.getOccurrences();
            sum = AmaltheaServices2.addTime(sum, AmaltheaServices2.multiply(avg, entry.getOccurrences()));
        }
        if (count == 0L) {
            return null;
        }
        return AmaltheaServices2.multiply(sum, 1.0 / (double)count);
    }

    public static @Nullable Double getAverage_DV(@NonNull Collection<DiscreteValueHistogramEntry> coll) {
        long count = 0L;
        double sum = 0.0;
        for (DiscreteValueHistogramEntry entry : coll) {
            if (entry == null) {
                return null;
            }
            Double avg = AmaltheaServices2.getAverage(entry.getLowerBound(), entry.getUpperBound());
            if (avg == null) {
                return null;
            }
            count += entry.getOccurrences();
            sum += avg * (double)entry.getOccurrences();
        }
        if (count == 0L) {
            return null;
        }
        return sum / (double)count;
    }

    public static @Nullable Double getAverage_CV(@NonNull Collection<ContinuousValueHistogramEntry> coll) {
        long count = 0L;
        double sum = 0.0;
        for (ContinuousValueHistogramEntry entry : coll) {
            if (entry == null) {
                return null;
            }
            Double avg = AmaltheaServices2.getAverage(entry.getLowerBound(), entry.getUpperBound());
            if (avg == null) {
                return null;
            }
            count += entry.getOccurrences();
            sum += avg * (double)entry.getOccurrences();
        }
        if (count == 0L) {
            return null;
        }
        return sum / (double)count;
    }

    public static @Nullable Time getLowerBound_Time(@NonNull Collection<? extends TimeInterval> coll) {
        Time min = null;
        for (TimeInterval timeInterval : coll) {
            if (timeInterval == null) {
                return null;
            }
            Time bound = timeInterval.getLowerBound();
            if (bound == null || AmaltheaServices2.isInvalid(bound)) {
                return null;
            }
            if (min != null && AmaltheaServices2.compareTimes(min, bound) <= 0) continue;
            min = bound;
        }
        return min;
    }

    public static @Nullable Long getLowerBound_DV(@NonNull Collection<? extends DiscreteValueInterval> coll) {
        Long min = null;
        for (DiscreteValueInterval discreteValueInterval : coll) {
            if (discreteValueInterval == null) {
                return null;
            }
            Long bound = discreteValueInterval.getLowerBound();
            if (min != null && min <= bound) continue;
            min = bound;
        }
        return min;
    }

    public static @Nullable Double getLowerBound_CV(@NonNull Collection<? extends ContinuousValueInterval> coll) {
        Double min = null;
        for (ContinuousValueInterval continuousValueInterval : coll) {
            if (continuousValueInterval == null) {
                return null;
            }
            Double bound = continuousValueInterval.getLowerBound();
            if (bound == null) {
                return null;
            }
            if (min != null && !(min > bound)) continue;
            min = bound;
        }
        return min;
    }

    public static @Nullable Time getUpperBound_Time(@NonNull Collection<? extends TimeInterval> coll) {
        Time max = null;
        for (TimeInterval timeInterval : coll) {
            if (timeInterval == null) {
                return null;
            }
            Time bound = timeInterval.getUpperBound();
            if (bound == null || AmaltheaServices2.isInvalid(bound)) {
                return null;
            }
            if (max != null && AmaltheaServices2.compareTimes(bound, max) <= 0) continue;
            max = bound;
        }
        return max;
    }

    public static @Nullable Long getUpperBound_DV(@NonNull Collection<? extends DiscreteValueInterval> coll) {
        Long max = null;
        for (DiscreteValueInterval discreteValueInterval : coll) {
            if (discreteValueInterval == null) {
                return null;
            }
            Long bound = discreteValueInterval.getUpperBound();
            if (bound == null) {
                return null;
            }
            if (max != null && max >= bound) continue;
            max = bound;
        }
        return max;
    }

    public static @Nullable Double getUpperBound_CV(@NonNull Collection<? extends ContinuousValueInterval> coll) {
        Double max = null;
        for (ContinuousValueInterval continuousValueInterval : coll) {
            if (continuousValueInterval == null) {
                return null;
            }
            Double bound = continuousValueInterval.getUpperBound();
            if (bound == null) {
                return null;
            }
            if (max != null && !(max < bound)) continue;
            max = bound;
        }
        return max;
    }

    public static @Nullable Time getAverageOfTruncatedNormalDistribution(@Nullable Time a, @Nullable Time b, @Nullable Time mean, @Nullable Time sd) {
        if (mean == null || sd == null) {
            return null;
        }
        if (AmaltheaServices2.isInvalid(mean) || AmaltheaServices2.isInvalid(sd)) {
            return null;
        }
        if (a != null && AmaltheaServices2.isInvalid(a)) {
            return null;
        }
        if (b != null && AmaltheaServices2.isInvalid(b)) {
            return null;
        }
        if (a != null && b != null && AmaltheaServices2.compareTimes(a, b) > 0) {
            return null;
        }
        return AmaltheaServices.getAverageOfTruncatedNormalDistribution(a, b, mean, sd);
    }

    public static @Nullable Double getAverageOfTruncatedNormalDistribution(@Nullable Number a, @Nullable Number b, @Nullable Double mean, @Nullable Double sd) {
        if (mean == null || sd == null) {
            return null;
        }
        if (a != null && b != null && a.doubleValue() > b.doubleValue()) {
            return null;
        }
        return AmaltheaServices.getAverageOfTruncatedNormalDistribution(a, b, mean, sd);
    }

    public static @Nullable Time getAverageOfBetaDistribution(@Nullable Time a, @Nullable Time b, @Nullable Double alpha, @Nullable Double beta) {
        if (a == null || b == null || alpha == null || beta == null) {
            return null;
        }
        if (AmaltheaServices2.isInvalid(a) || AmaltheaServices2.isInvalid(b)) {
            return null;
        }
        if (AmaltheaServices2.compareTimes(a, b) > 0) {
            return null;
        }
        if (alpha <= 0.0) {
            return null;
        }
        if (beta <= 0.0) {
            return null;
        }
        double ratio = 1.0 / (1.0 + beta / alpha);
        return AmaltheaServices2.addTime(a, AmaltheaServices2.multiply(AmaltheaServices2.subtractTime(b, a), ratio));
    }

    public static @Nullable Double getAverageOfBetaDistribution(@Nullable Number a, @Nullable Number b, @Nullable Double alpha, @Nullable Double beta) {
        double b_double;
        if (a == null || b == null || alpha == null || beta == null) {
            return null;
        }
        double a_double = a.doubleValue();
        if (a_double > (b_double = b.doubleValue())) {
            return null;
        }
        if (alpha <= 0.0) {
            return null;
        }
        if (beta <= 0.0) {
            return null;
        }
        double ratio = 1.0 / (1.0 + beta / alpha);
        return a_double + (b_double - a_double) * ratio;
    }
}

