/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter.atdb;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.app4mc.tracing.converter.atdb.ATDBWriter;
import org.eclipse.app4mc.tracing.converter.atdb.OT1Loader;
import org.eclipse.app4mc.tracing.converter.atdb.model.EntityType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.OT1Type1;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityType;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ATDBConvertHandler
extends AbstractHandler
implements IRunnableWithProgress {
    private IFile iFile;
    private IFile atdbFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty()) {
            return null;
        }
        if (!(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)currentSelection;
        Object[] array = ssel.toArray();
        if (array.length != 1) {
            return null;
        }
        Object obj = array[0];
        if (!(obj instanceof IFile)) {
            return null;
        }
        try {
            this.iFile = (IFile)obj;
            this.convert(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private void convert(ExecutionEvent event) throws InterruptedException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String name = this.iFile.getName();
        IPath atdbFilePath = new Path(name).removeFileExtension().addFileExtension("atdb");
        this.atdbFile = this.iFile.getParent().getFile(atdbFilePath);
        if (this.atdbFile.getLocation().toFile().exists()) {
            boolean openConfirm = MessageDialog.openConfirm((Shell)activeShell, (String)"AMALTHEA Trace DB already exists.", (String)("There exists already an AMALTHEA Trace DB at location: " + atdbFilePath.toOSString() + "\n\nDo you want to replace that file?"));
            if (!openConfirm) {
                return;
            }
            File file = this.atdbFile.getLocation().toFile();
            if (!file.delete()) {
                MessageDialog.openError((Shell)activeShell, (String)"Deletion failed", (String)("Couldn't delete existing Trace Database: " + file.getAbsolutePath()));
                return;
            }
        }
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(activeShell);
        try {
            pmd.run(false, false, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            ErrorDialog.openError((Shell)activeShell, (String)"Error", (String)"Something went wrong during conversion", (IStatus)new Status(4, "org.eclipse.app4mc.tracing.converter.atdb", e.getMessage(), e.getTargetException()));
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Converting OT1 to AMALTHEA Trace Database (ATDB) format.", 100);
            monitor.subTask("Loading OT1-Model");
            OT1Type1 loadOT1Model = OT1Loader.loadOT1Model(this.iFile);
            monitor.worked(20);
            monitor.subTask("Creating initial ATDB structure");
            try (ATDBWriter atdbWriter = new ATDBWriter();){
                atdbWriter.createATDB(this.atdbFile);
                monitor.worked(5);
                EList schedulingEntities = loadOT1Model.getSchedulingEntity();
                for (SchedulingEntityType schedEntityType : schedulingEntities) {
                    try {
                        EList element = schedEntityType.getElement();
                        monitor.subTask("Insert entities for " + schedEntityType.getName());
                        atdbWriter.insertEntities(schedEntityType, (Collection<SchedulingEntityElementType>)element);
                        monitor.worked(5);
                        monitor.subTask("Insert event-types for " + schedEntityType.getName());
                        atdbWriter.insertEventTypes(schedEntityType);
                        monitor.worked(5);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (SchedulingEntityType schedEntityType : schedulingEntities) {
                    try {
                        Long insertEntity = atdbWriter.insertEntity(schedEntityType, EntityType.CORE);
                        monitor.subTask("Insert trace-entries for " + schedEntityType.getName());
                        if (insertEntity == null) continue;
                        atdbWriter.insertTraceEntries(schedEntityType, insertEntity);
                        monitor.worked(50);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    monitor.subTask("Insert EntitySource entries.");
                    atdbWriter.fillEntitySource();
                    monitor.worked(10);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                monitor.subTask("Set meta-information.");
                atdbWriter.fillMetaInformation(this.iFile.getLocation().toFile().getAbsolutePath());
                monitor.worked(1);
            }
            monitor.subTask("Finished.");
            this.atdbFile.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

