/**
 ********************************************************************************
 * Copyright (c) 2020 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */ 
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

import javax.inject.Named;

import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmaltheaResourceExpression {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(AmaltheaResourceExpression.class); 
	
	@Evaluate
	public boolean evaluate(@Optional @Named(IServiceConstants.ACTIVE_SELECTION) IStructuredSelection selection) {
		if (selection != null && !selection.isEmpty()
				&& selection.size() == 1
				&& selection.getFirstElement() instanceof IResource) {
			
			IResource resource = (IResource) selection.getFirstElement();
			if (resource instanceof IFile && MigrationHelper.isModelFileExtension(resource.getFileExtension())) {
				return true;
			}
			
			if (resource instanceof IContainer) {
				// check if there are amxmi files in the folder or project
				IContainer folder = (IContainer) resource;
				Path modelFilePath = Paths.get(folder.getLocationURI());
				
				try (Stream<Path> directoryStream = Files.walk(modelFilePath, Integer.MAX_VALUE)) {
					return directoryStream
							.filter(Files::isRegularFile)
							.anyMatch(file -> MigrationHelper.isModelFile(file.toString()));
					
				} catch (IOException e) {
					LOGGER.error("Failed to collect model files", e);
				}	

			}
		}
		return false;
	}
	
}
