/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf;

import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BTFImporter
implements IRunnableWithProgress {
    private final String btfFile;
    private final ATDBConnection con;
    private final Map<String, String> entity2Type = new LinkedHashMap<String, String>();
    private final Set<String> entityTypes = new HashSet<String>();
    private final Set<String> instNames = new HashSet<String>();
    private final Set<String> eventTypes = new HashSet<String>();
    private final Map<String, Map<String, List<String>>> entity2property2Value = new LinkedHashMap<String, Map<String, List<String>>>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    public BTFImporter(ATDBConnection con, String btfFile) {
        this.con = con;
        this.btfFile = btfFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Importing BTF file...", (int)6);
        SubMonitor readingBTFMonitor = subMon.split(5);
        readingBTFMonitor.beginTask("Reading BTF file...", 10000);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream fis = new FileInputStream(this.btfFile);
                try {
                    Scanner sc = new Scanner((InputStream)fis, "UTF-8");
                    try {
                        try (Statement propStmt = this.con.createStatement();){
                            PreparedStatement metaStmt = this.con.getPreparedStatementFor("INSERT INTO metaInformation VALUES(?, ?);");
                            PreparedStatement entTStmt = this.con.getPreparedStatementFor("INSERT INTO entityType(name) VALUES(?);");
                            PreparedStatement entStmt = this.con.getPreparedStatementFor("INSERT INTO entity(name, entityTypeId) VALUES(?,(SELECT id FROM entityType WHERE name = ?));");
                            PreparedStatement instStmt = this.con.getPreparedStatementFor("INSERT INTO entityInstance VALUES((SELECT id FROM entity WHERE name = ?), ?);");
                            PreparedStatement evTStmt = this.con.getPreparedStatementFor("INSERT INTO eventType(name) VALUES(?);");
                            PreparedStatement evStmt = this.con.getPreparedStatementFor("INSERT INTO traceEvent VALUES(?, ?,(SELECT id FROM entity WHERE name = ?), ?,(SELECT id FROM entity WHERE name = ?), ?,(SELECT id FROM eventType WHERE name = ?), ?)");
                            long fileSize = new File(this.btfFile).length();
                            long currentTimestamp = Long.MIN_VALUE;
                            int currentSQCNR = 0;
                            String currentECU = "";
                            String currentProcessor = "";
                            long currentLineNumber = 0L;
                            long lineLengthSum = 0L;
                            long avgLineLength = 64L;
                            HashBiMap actCore2Process = HashBiMap.create();
                            HashBiMap actProcess2Runnable = HashBiMap.create();
                            while (sc.hasNextLine()) {
                                String line;
                                block66: {
                                    block65: {
                                        Optional value;
                                        String eventType;
                                        int sourceInstance;
                                        String sourceName;
                                        int entityInstance;
                                        String entityName;
                                        String entityType;
                                        long newTimestamp;
                                        block69: {
                                            block67: {
                                                ++currentLineNumber;
                                                line = sc.nextLine();
                                                if (line.startsWith("#")) break block65;
                                                String[] fields = line.split(",");
                                                if (fields.length <= 6) break block66;
                                                newTimestamp = Long.parseLong(fields[0]);
                                                entityType = fields[3];
                                                entityName = fields[4];
                                                entityInstance = Integer.parseInt(fields[5]);
                                                sourceName = fields[1];
                                                sourceInstance = Integer.parseInt(fields[2]);
                                                eventType = fields[6];
                                                value = fields.length > 7 ? Optional.of(fields[7]) : Optional.empty();
                                                this.insertEntity(entTStmt, entityName, entityType);
                                                if (!eventType.equalsIgnoreCase("tag") || !value.isPresent()) break block67;
                                                String sourceType = "";
                                                switch ((String)value.get()) {
                                                    case "ECU_INIT": {
                                                        sourceType = "ECU";
                                                        currentECU = sourceName;
                                                        break;
                                                    }
                                                    case "PROCESSOR_INIT": {
                                                        sourceType = "Processor";
                                                        currentProcessor = sourceName;
                                                        this.appendToProperty(currentECU, "processors", "entityIdRef", sourceName);
                                                        break;
                                                    }
                                                    case "CORE_INIT": {
                                                        sourceType = "C";
                                                        this.appendToProperty(currentProcessor, "cores", "entityIdRef", sourceName);
                                                        break;
                                                    }
                                                    case "SIG_INIT_VALUE": {
                                                        sourceType = "SIG";
                                                        if (fields.length <= 8) break;
                                                        this.setProperty(sourceName, "initialValue", "object", fields[8]);
                                                        break;
                                                    }
                                                    default: {
                                                        this.setProperty(sourceName, "tag", "object", (String)value.get());
                                                    }
                                                }
                                                if (sourceType.isEmpty()) break block69;
                                                this.insertEntity(entTStmt, sourceName, sourceType);
                                                break block69;
                                            }
                                            if (eventType.equalsIgnoreCase("set_frequence") && value.isPresent()) {
                                                this.setProperty(entityName, "frequencyInHz", "long", (String)value.get());
                                                continue;
                                            }
                                            if ((eventType.equalsIgnoreCase("start") || eventType.equalsIgnoreCase("stop")) && entityType.equals("SYS")) {
                                                this.setProperty(entityName, "system" + eventType.substring(0, 1).toUpperCase() + eventType.substring(1) + "Time", "time", "" + newTimestamp);
                                                continue;
                                            }
                                        }
                                        if (BTFEntityType.PROCESS.isTraceAlias(entityType) && "C".equals(this.entity2Type.getOrDefault(sourceName, "")) && (!this.entity2property2Value.containsKey(entityName) || !this.entity2property2Value.get(entityName).containsKey("executingCore"))) {
                                            this.setProperty(entityName, "executingCore", "entityIdRef", sourceName);
                                        }
                                        if (!(!BTFEntityType.RUNNABLE.isTraceAlias(entityType) || !BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) || this.entity2property2Value.containsKey(sourceName) && this.entity2property2Value.get(sourceName).containsKey("runnables") && this.entity2property2Value.get(sourceName).get("runnables").contains(entityName))) {
                                            this.appendToProperty(sourceName, "runnables", "entityIdRef", entityName);
                                        }
                                        if (eventType.equalsIgnoreCase("activate") && BTFEntityType.PROCESS.isTraceAlias(entityType)) {
                                            this.insertEntity(entTStmt, sourceName, "STI");
                                            if (!(this.entity2property2Value.containsKey(entityName) && this.entity2property2Value.get(entityName).containsKey("stimuli") && this.entity2property2Value.get(entityName).get("stimuli").contains(sourceName))) {
                                                this.appendToProperty(entityName, "stimuli", "entityIdRef", sourceName);
                                            }
                                        } else {
                                            this.insertEntity(entTStmt, sourceName, "");
                                        }
                                        this.insertEntityInstance(instStmt, sourceName, sourceInstance);
                                        this.insertEntityInstance(instStmt, entityName, entityInstance);
                                        if (eventType.equalsIgnoreCase("tag")) continue;
                                        if (newTimestamp > currentTimestamp) {
                                            currentSQCNR = 0;
                                            currentTimestamp = newTimestamp;
                                        } else {
                                            ++currentSQCNR;
                                        }
                                        this.insertEventType(evTStmt, eventType);
                                        if (BTFEntityType.PROCESS.isTraceAlias(entityType) && "C".equals(this.entity2Type.getOrDefault(sourceName, ""))) {
                                            if (eventType.equalsIgnoreCase("start")) {
                                                actCore2Process.put((Object)sourceName, (Object)entityName);
                                            } else if (eventType.equalsIgnoreCase("terminate")) {
                                                actCore2Process.remove((Object)sourceName);
                                            }
                                        }
                                        if (BTFEntityType.RUNNABLE.isTraceAlias(entityType) && BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) && actCore2Process.containsValue((Object)sourceName)) {
                                            if (eventType.equalsIgnoreCase("start")) {
                                                actProcess2Runnable.put((Object)sourceName, (Object)entityName);
                                            } else if (eventType.equalsIgnoreCase("terminate")) {
                                                actProcess2Runnable.remove((Object)sourceName);
                                            }
                                        }
                                        if (entityType.equals("SIG") && BTFEntityType.PROCESS.isTraceAlias(this.entity2Type.getOrDefault(sourceName, "")) && actProcess2Runnable.containsKey((Object)sourceName)) {
                                            String rName = (String)actProcess2Runnable.get((Object)sourceName);
                                            if (!(!eventType.equalsIgnoreCase("read") || this.entity2property2Value.containsKey(rName) && this.entity2property2Value.get(rName).containsKey("readSignals") && this.entity2property2Value.get(rName).get("readSignals").contains(entityName))) {
                                                this.appendToProperty(rName, "readSignals", "entityIdRef", entityName);
                                            } else if (!(!eventType.equalsIgnoreCase("write") || this.entity2property2Value.containsKey(rName) && this.entity2property2Value.get(rName).containsKey("writtenSignals") && this.entity2property2Value.get(rName).get("writtenSignals").contains(entityName))) {
                                                this.appendToProperty(rName, "writtenSignals", "entityIdRef", entityName);
                                            }
                                        }
                                        evStmt.setLong(1, currentTimestamp);
                                        evStmt.setInt(2, currentSQCNR);
                                        evStmt.setString(3, entityName);
                                        evStmt.setInt(4, entityInstance);
                                        evStmt.setString(5, sourceName);
                                        evStmt.setInt(6, sourceInstance);
                                        evStmt.setString(7, eventType);
                                        if (value.isPresent()) {
                                            evStmt.setString(8, (String)value.get());
                                        } else {
                                            evStmt.setNull(8, 12);
                                        }
                                        evStmt.addBatch();
                                        break block66;
                                    }
                                    if (line.toLowerCase().startsWith("#timescale")) {
                                        metaStmt.setString(1, "timeBase");
                                        metaStmt.setString(2, line.substring(11));
                                        metaStmt.addBatch();
                                    } else if (line.startsWith("#simulation_duration")) {
                                        this.setProperty("SIM", "simulationDuration", "time", line.substring(21, line.lastIndexOf(32)));
                                    }
                                }
                                if (currentLineNumber % 256L != 0L) continue;
                                lineLengthSum += (long)line.length();
                                if (currentLineNumber % 65536L != 0L) continue;
                                avgLineLength = avgLineLength + (lineLengthSum >> 8) >> 1;
                                lineLengthSum = 0L;
                                long numberOfLines = fileSize / avgLineLength;
                                readingBTFMonitor.setWorkRemaining(10000 - (int)Math.min(10000L, currentLineNumber * 10000L / numberOfLines));
                            }
                            this.executeEntityInsertStatements(entStmt);
                            this.executePropertyInsertStatements(propStmt);
                            readingBTFMonitor.done();
                            SubMonitor writeEventsMonitor = subMon.split(1);
                            writeEventsMonitor.beginTask("Writing events to data base...", 1);
                            this.con.executeBatchStatements(new Statement[]{metaStmt, entTStmt, entStmt, instStmt, evTStmt, evStmt, propStmt});
                            writeEventsMonitor.done();
                        }
                        if (sc != null) {
                            sc.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (sc == null) throw throwable;
                        sc.close();
                        throw throwable;
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | SQLException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void insertEntity(PreparedStatement tStmt, String name, String entityType) throws SQLException {
        if (!entityType.isEmpty() && this.entityTypes.add(entityType)) {
            tStmt.setString(1, entityType);
            tStmt.addBatch();
        }
        this.entity2Type.compute(name, (k, v) -> v == null || v.isEmpty() ? entityType : v);
    }

    private void executeEntityInsertStatements(PreparedStatement eStmt) throws SQLException {
        for (Map.Entry<String, String> entry : this.entity2Type.entrySet()) {
            String entityName = entry.getKey();
            String entityType = entry.getValue();
            eStmt.setString(1, entityName);
            eStmt.setString(2, entityType);
            eStmt.addBatch();
        }
    }

    private void insertEntityInstance(PreparedStatement stmt, String name, int inst) throws SQLException {
        String srcInstName = String.valueOf(name) + "#" + inst;
        if (this.instNames.add(srcInstName)) {
            stmt.setString(1, name);
            stmt.setInt(2, inst);
            stmt.addBatch();
        }
    }

    private void insertEventType(PreparedStatement stmt, String name) throws SQLException {
        if (this.eventTypes.add(name)) {
            stmt.setString(1, name);
            stmt.addBatch();
        }
    }

    private void appendToProperty(String entityName, String propertyName, String propertyType, String propertyValue) {
        this.setProperty(entityName, propertyName, propertyType, propertyValue, true);
    }

    private void setProperty(String entityName, String propertyName, String propertyType, String propertyValue) {
        this.setProperty(entityName, propertyName, propertyType, propertyValue, false);
    }

    private void setProperty(String entityName, String propertyName, String propertyType, String propertyValue, boolean append) {
        this.properties.putIfAbsent(propertyName, propertyType);
        Map property2Value = this.entity2property2Value.computeIfAbsent(entityName, k -> new LinkedHashMap());
        List values = property2Value.computeIfAbsent(propertyName, k -> new ArrayList());
        if (!append) {
            values.clear();
        }
        values.add(propertyValue);
    }

    private void executePropertyInsertStatements(Statement stmt) throws SQLException {
        ArrayList statements = new ArrayList();
        this.properties.forEach((propertyName, propertyType) -> {
            boolean bl = statements.add("INSERT INTO property(name, type) VALUES('" + propertyName + "', '" + propertyType + "');");
        });
        this.entity2property2Value.forEach((entityName, property2Value) -> property2Value.forEach((propertyName, propertyValue) -> {
            ArrayList<String> propertyValueStrings = new ArrayList<String>();
            String propertyType = this.properties.get(propertyName);
            if (propertyType.endsWith("IdRef")) {
                String tableName = propertyType.substring(0, propertyType.lastIndexOf("IdRef"));
                propertyValue.forEach(pv -> {
                    boolean bl = propertyValueStrings.add("(SELECT id FROM " + tableName + " WHERE name = '" + pv + "')");
                });
            } else {
                propertyValueStrings.add("'" + String.join((CharSequence)", ", propertyValue) + "'");
            }
            int i = 0;
            while (i < propertyValueStrings.size()) {
                statements.add("INSERT INTO propertyValue(entityId, propertyId, sqcnr, value) VALUES((SELECT id FROM entity   WHERE name = '" + entityName + "'), " + "(SELECT id FROM property WHERE name = '" + propertyName + "'), " + i + "," + (String)propertyValueStrings.get(i) + ");");
                ++i;
            }
        }));
        for (String st : statements) {
            stmt.addBatch(st);
        }
    }
}

