/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.emf;

import java.util.HashMap;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.util.AmaltheaValidator;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Validation(id="AM-EMF-INTRINSIC", checks={"EMF extended metadata constraints (generated)", "AMALTHEA invariants (generated)"})
public class AmEmfIntrinsic
implements IValidation {
    private final HashMap<Object, Object> CONTEXT = AmEmfIntrinsic.createContextMap();

    public EPackage getEPackage() {
        return AmaltheaPackage.eINSTANCE;
    }

    public EClassifier getEClassifier() {
        return EcorePackage.eINSTANCE.getEObject();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> resultList) {
        EPackage _ePackage;
        boolean _tripleEquals;
        EObject _eContainer = eObject.eClass().eContainer();
        boolean bl = _tripleEquals = _eContainer == (_ePackage = this.getEPackage());
        if (_tripleEquals) {
            BasicDiagnostic diagnostics = new BasicDiagnostic();
            boolean valid = AmaltheaValidator.INSTANCE.validate(eObject.eClass(), eObject, (DiagnosticChain)diagnostics, this.CONTEXT);
            if (!valid) {
                List _children = diagnostics.getChildren();
                for (Diagnostic emfDiagnostic : _children) {
                    Functions.Function1 _function = e -> e instanceof EObject;
                    Object _findFirst = IterableExtensions.findFirst((Iterable)emfDiagnostic.getData(), (Functions.Function1)_function);
                    EObject problematicObject = (EObject)_findFirst;
                    Functions.Function1 _function_1 = e -> e instanceof EStructuralFeature;
                    Object _findFirst_1 = IterableExtensions.findFirst((Iterable)emfDiagnostic.getData(), (Functions.Function1)_function_1);
                    EStructuralFeature problematicFeature = (EStructuralFeature)_findFirst_1;
                    String _message = emfDiagnostic.getMessage();
                    String _objectOrContainerInfo = this.objectOrContainerInfo(problematicObject);
                    String _plus = String.valueOf(_message) + _objectOrContainerInfo;
                    Functions.Function1 _function_2 = it -> it.getMessage();
                    Functions.Function1 _function_3 = it -> it.trim();
                    String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)emfDiagnostic.getChildren(), (Functions.Function1)_function_2), (CharSequence)" => ", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function_3);
                    String _plus_1 = String.valueOf(_plus) + _join;
                    EObject _xifexpression = null;
                    _xifexpression = problematicObject != null ? problematicObject : eObject;
                    ValidationDiagnostic result = new ValidationDiagnostic(_plus_1, _xifexpression, problematicFeature);
                    Severity _switchResult = null;
                    int _severity = emfDiagnostic.getSeverity();
                    switch (_severity) {
                        case 1: {
                            _switchResult = Severity.INFO;
                            break;
                        }
                        case 2: {
                            _switchResult = Severity.WARNING;
                            break;
                        }
                        case 4: {
                            _switchResult = Severity.ERROR;
                            break;
                        }
                        default: {
                            _switchResult = Severity.UNDEFINED;
                        }
                    }
                    result.setSeverityLevel(_switchResult);
                    resultList.add(result);
                }
            }
        }
    }

    private String objectOrContainerInfo(EObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof IReferable && !StringExtensions.isNullOrEmpty((String)((IReferable)object).getName())) {
            String _objectInfo = this.objectInfo(object);
            String _plus = " ( in " + _objectInfo;
            return String.valueOf(_plus) + " )";
        }
        IReferable container = (IReferable)AmaltheaServices.getContainerOfType((EObject)object, IReferable.class);
        if (container == null || StringExtensions.isNullOrEmpty((String)container.getName())) {
            return "";
        }
        String _objectInfo_1 = this.objectInfo((EObject)container);
        String _plus_1 = " ( in " + _objectInfo_1;
        return String.valueOf(_plus_1) + " )";
    }

    private static HashMap<Object, Object> createContextMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(EValidator.SubstitutionLabelProvider.class, new EValidator.SubstitutionLabelProvider(){

            public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
                return eStructuralFeature.getName();
            }

            public String getObjectLabel(EObject eObject) {
                String _xblockexpression = null;
                String s1 = eObject.eClass().getName();
                String _xifexpression = null;
                if (eObject instanceof INamed) {
                    String _name = ((INamed)eObject).getName();
                    _xifexpression = " " + _name;
                } else {
                    _xifexpression = "";
                }
                String s2 = _xifexpression;
                _xblockexpression = String.valueOf(s1) + s2;
                return _xblockexpression;
            }

            public String getValueLabel(EDataType eDataType, Object value) {
                return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }
        });
        return map;
    }
}

