/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.app4mc.amalthea._import.atdb.ImportTransformation;
import org.eclipse.app4mc.amalthea._import.atdb.handler.ATDB2AMXMIImport;
import org.eclipse.app4mc.amalthea._import.atdb.wizard.ImportPage;
import org.eclipse.app4mc.amalthea._import.atdb.wizard.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.FrameworkUtil;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportPage mainPage;
    private IStructuredSelection selection;

    public void addPages() {
        super.addPages();
        this.mainPage = new ImportPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)selection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle(Messages.ImportWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        String atdbSource = this.mainPage.getATDBSource();
        IFile amxmiTarget = this.mainPage.getAMXMITarget();
        boolean extractLabelsAndAccesses = this.mainPage.isExtractLabelsAndAccesses();
        boolean extractRunnableRuntimes = this.mainPage.isExtractRunnableRuntimes();
        boolean overwriteExisting = this.mainPage.isOverwriteExisting();
        return ImportWizard.importAndOpenInIDE(atdbSource, amxmiTarget, extractLabelsAndAccesses, extractRunnableRuntimes, overwriteExisting, (IRunnableContext)this.getContainer());
    }

    public static boolean importAndOpenInIDE(final String atdbSource, final IFile amxmiTarget, final boolean extractLabelsAndAccesses, final boolean extractRunnableRuntimes, final boolean overwriteExisting, IRunnableContext runnableContext) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
                ImportTransformation transformer = new ImportTransformation(atdbSource, amxmiTarget.getLocation().toString(), extractLabelsAndAccesses, extractRunnableRuntimes, overwriteExisting);
                transformer.run(progressMonitor);
                amxmiTarget.refreshLocal(1, progressMonitor);
                progressMonitor.done();
            }
        };
        try {
            runnableContext.run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e1) {
            Platform.getLog(ATDB2AMXMIImport.class).log((IStatus)new Status(4, FrameworkUtil.getBundle(ATDB2AMXMIImport.class).getSymbolicName(), e1.getLocalizedMessage(), (Throwable)e1));
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)amxmiTarget);
        }
        catch (PartInitException e) {
            Platform.getLog(ATDB2AMXMIImport.class).log((IStatus)new Status(4, FrameworkUtil.getBundle(ATDB2AMXMIImport.class).getSymbolicName(), e.getLocalizedMessage(), (Throwable)e));
            return false;
        }
        return true;
    }
}

