/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.software;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ModeCondition;
import org.eclipse.app4mc.amalthea.model.ModeConditionConjunction;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.ModeValueCondition;
import org.eclipse.app4mc.amalthea.model.RelationalOperator;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Software-ModeConditionConjunctionAlwaysFalse")
public class TASoftwareModeConditionConjunctionAlwaysFalse
extends AmaltheaValidation {
    private static final String ALWAYS_EVALUATES_TO_FALSE = " always evaluates to FALSE, which might not be intended here.";

    public EClassifier getEClassifier() {
        return ePackage.getModeConditionConjunction();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof ModeConditionConjunction) {
            ModeConditionConjunction mcc = (ModeConditionConjunction)eObject;
            List andedEMCs = mcc.getEntries().stream().filter(ModeValueCondition.class::isInstance).map(ModeValueCondition.class::cast).filter(mc -> mc.eIsSet((EStructuralFeature)ePackage.getModeValue_Value()) && mc.eIsSet((EStructuralFeature)ePackage.getModeValue_Label()) && mc.getLabel().isEnum() && mc.getLiteral() != null).distinct().collect(Collectors.toList());
            andedEMCs.stream().collect(Collectors.groupingBy(ModeValue::getLabel)).forEach((ml, mcs) -> {
                List allUnEQLiterals;
                INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)mcc, INamed.class);
                List allEQLiterals = mcs.stream().filter(mc -> mc.getRelation() == RelationalOperator.EQUAL).map(ModeValue::getLiteral).distinct().map(INamed::getName).collect(Collectors.toList());
                if (allEQLiterals.size() > 1) {
                    this.addIssue(results, (EObject)mcc, (EStructuralFeature)ePackage.getModeConditionConjunction_Entries(), "Conjoining equality of mode literals " + allEQLiterals + " in " + this.objectInfo((EObject)namedContainer) + ALWAYS_EVALUATES_TO_FALSE);
                }
                if ((allUnEQLiterals = mcs.stream().filter(mc -> mc.getRelation() == RelationalOperator.NOT_EQUAL).map(ModeValue::getLiteral).distinct().map(INamed::getName).collect(Collectors.toList())).size() > 1) {
                    this.addIssue(results, (EObject)mcc, (EStructuralFeature)ePackage.getModeConditionConjunction_Entries(), "Conjoining unequality of mode literals " + allUnEQLiterals + " in " + this.objectInfo((EObject)namedContainer) + ALWAYS_EVALUATES_TO_FALSE);
                }
                mcs.stream().collect(Collectors.groupingBy(ModeValue::getLiteral)).forEach((lit, litMCs) -> {
                    List usedRelations = litMCs.stream().map(ModeCondition::getRelation).distinct().collect(Collectors.toList());
                    if (usedRelations.contains(RelationalOperator.EQUAL) && usedRelations.contains(RelationalOperator.NOT_EQUAL)) {
                        this.addIssue(results, (EObject)mcc, (EStructuralFeature)ePackage.getModeConditionConjunction_Entries(), "Conjoining mode conditions on the same " + this.objectInfo((EObject)lit) + " with relations " + usedRelations + " in " + this.objectInfo((EObject)namedContainer) + ALWAYS_EVALUATES_TO_FALSE);
                    }
                });
            });
        }
    }
}

