/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.os;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.UserSpecificSchedulingAlgorithm;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-OS-UserSpecificSchedulerCheck", checks={"User specific task scheduler needs at least one task allocation"})
public class InchronOsUserSpecificSchedulerCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getUserSpecificSchedulingAlgorithm();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        UserSpecificSchedulingAlgorithm schedAlg;
        EObject obj;
        if (eObject instanceof UserSpecificSchedulingAlgorithm && (obj = (schedAlg = (UserSpecificSchedulingAlgorithm)eObject).eContainer()) instanceof TaskScheduler) {
            TaskScheduler sched = (TaskScheduler)obj;
            EList listTaskAlloc = sched.getTaskAllocations();
            EList listRunAlloc = sched.getRunnableAllocations();
            if (listTaskAlloc.isEmpty() && listRunAlloc.isEmpty()) {
                this.addIssue(results, (EObject)schedAlg, null, "User Specific Task Scheduler Algorithm " + this.name((INamed)sched) + " needs at least one task/runnable allocation");
            }
        }
    }
}

