/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocalArchetypeCatalogDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS = LocalArchetypeCatalogDialog.class.getName();
    private static final String KEY_LOCATIONS = "catalogLocation";
    private static final int MAX_HISTORY = 15;
    private String title;
    private String message;
    Combo catalogLocationCombo;
    private Text catalogDescriptionText;
    private IDialogSettings dialogSettings;
    private ArchetypeCatalogFactory archetypeCatalogFactory;

    protected LocalArchetypeCatalogDialog(Shell shell, ArchetypeCatalogFactory factory) {
        super(shell);
        this.archetypeCatalogFactory = factory;
        this.title = Messages.LocalArchetypeCatalogDialog_title;
        this.message = Messages.LocalArchetypeCatalogDialog_message;
        this.setShellStyle(2144);
        this.setHelpAvailable(false);
        IDialogSettings pluginSettings = M2EUIPluginActivator.getDefault().getDialogSettings();
        this.dialogSettings = pluginSettings.getSection(DIALOG_SETTINGS);
        if (this.dialogSettings == null) {
            this.dialogSettings = new DialogSettings(DIALOG_SETTINGS);
            pluginSettings.addSection(this.dialogSettings);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite1 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(composite1, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label catalogLocationLabel = new Label(composite, 0);
        catalogLocationLabel.setText(Messages.LocalArchetypeCatalogDialog_lblCatalog);
        this.catalogLocationCombo = new Combo(composite, 0);
        GridData gd_catalogLocationCombo = new GridData(4, 0x1000000, true, false);
        gd_catalogLocationCombo.widthHint = 250;
        this.catalogLocationCombo.setLayoutData((Object)gd_catalogLocationCombo);
        this.catalogLocationCombo.setItems(this.getSavedValues(KEY_LOCATIONS));
        Button browseButton = new Button(composite, 0);
        browseButton.setText(Messages.LocalArchetypeCatalogDialog_btnBrowse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LocalArchetypeCatalogDialog.this.getShell());
                dialog.setText(Messages.LocalArchetypeCatalogDialog_dialog_title);
                String location = dialog.open();
                if (location != null) {
                    LocalArchetypeCatalogDialog.this.catalogLocationCombo.setText(location);
                    LocalArchetypeCatalogDialog.this.update();
                }
            }
        });
        this.setButtonLayoutData(browseButton);
        Label catalogDescriptionLabel = new Label(composite, 0);
        catalogDescriptionLabel.setText(Messages.LocalArchetypeCatalogDialog_lblDesc);
        this.catalogDescriptionText = new Text(composite, 2048);
        this.catalogDescriptionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.archetypeCatalogFactory != null) {
            this.catalogLocationCombo.setText(this.archetypeCatalogFactory.getId());
            this.catalogDescriptionText.setText(this.archetypeCatalogFactory.getDescription());
        }
        ModifyListener modifyListener = e -> this.update();
        this.catalogLocationCombo.addModifyListener(modifyListener);
        this.catalogDescriptionText.addModifyListener(modifyListener);
        return composite;
    }

    private String[] getSavedValues(String key) {
        String[] array = this.dialogSettings.getArray(key);
        return array == null ? new String[]{} : array;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        String description = this.catalogDescriptionText.getText().trim();
        String location = this.catalogLocationCombo.getText().trim();
        this.archetypeCatalogFactory = new ArchetypeCatalogFactory.LocalCatalogFactory(location, description, true);
        this.saveValue(KEY_LOCATIONS, location);
        super.okPressed();
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory() {
        return this.archetypeCatalogFactory;
    }

    private void saveValue(String key, String value) {
        List dirs = new ArrayList<String>();
        dirs.addAll(Arrays.asList(this.getSavedValues(key)));
        dirs.remove(value);
        dirs.add(0, value);
        if (dirs.size() > 15) {
            dirs = dirs.subList(0, 15);
        }
        this.dialogSettings.put(key, dirs.toArray(new String[dirs.size()]));
    }

    void update() {
        boolean isValid = this.isValid();
        this.getButton(0).setEnabled(isValid);
    }

    private boolean isValid() {
        ArchetypeCatalog archetypeCatalog;
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        String location = this.catalogLocationCombo.getText().trim();
        if (location.length() == 0) {
            this.setErrorMessage(Messages.LocalArchetypeCatalogDialog_error_no_location);
            return false;
        }
        if (!new File(location).exists()) {
            this.setErrorMessage(Messages.LocalArchetypeCatalogDialog_error_exist);
            return false;
        }
        ArchetypeCatalogFactory.LocalCatalogFactory factory = new ArchetypeCatalogFactory.LocalCatalogFactory(location, null, true);
        try {
            archetypeCatalog = factory.getArchetypeCatalog();
        }
        catch (CoreException ex) {
            this.setMessage(NLS.bind((String)Messages.LocalArchetypeCatalogDialog_error, (Object)ex.getMessage()), 4);
            return false;
        }
        List archetypes = archetypeCatalog.getArchetypes();
        if (archetypes == null || archetypes.size() == 0) {
            this.setMessage(Messages.LocalArchetypeCatalogDialog_error_empty, 2);
        }
        return true;
    }
}

